<?php

use Gek\Collections\ArrayList;
use Gek\Collections\Enumerable;
use Gek\Collections\IList;
use Gek\FileFinder\FileFinder;
use Gek\FileFinder\FileInfo;
use Gek\Filesystem\Filesystem;
use Gek\Infrastructure\Str;
use Gek\PhpLang\ClassField;
use Gek\PhpLang\CodeFactory;
use Gek\PhpLang\TraitItem;
use PhpParser\NodeTraverser;
use PhpParser\NodeVisitorAbstract;
use PhpParser\ParserFactory;

include_once __DIR__ . "/vendor/autoload.php";

$ordId = "454_ass_ded-sdasd";
if(Str::contains($ordId,"_")){
    $index = Str::indexOf($ordId,"_");
    $ordId = substr($ordId,0,$index);
}

var_dump($ordId);
exit(0);

$basePath  ='C:\works\ibb\bahçe_market\bahcemarketyedek\bahcemarketyedek';
$fs = new Filesystem();
$fileInfo = new SplFileInfo(__DIR__.DIRECTORY_SEPARATOR . "testDir");

var_dump($fileInfo->getMTime());
var_dump('Last changed at ' . date("F d Y H:i:s.", $fileInfo->getMTime()));
exit(0);
$files = FileFinder::create()
    ->pathFilter("Views")
    ->nameFilter("List.php")
    ->in($basePath)
    ->asEnumerable()
    ->where(fn(FileInfo $fi) => false == Str::contains($fi->getContents(),'assets/js/custom/datatables/datatables.uikit.js'))
    ->where(fn(FileInfo $fi) => Str::contains($fi->getContents(),'bower_components/datatables-buttons/js/buttons.print.js'));
/** @var FileInfo $file */
foreach ($files as $file){
    $content = $file->getContents();
    $content = str_replace(["\r","\n"],PHP_EOL,$content);
    $lines = new ArrayList(explode(PHP_EOL,$content));
    $filter = $lines->where(fn($i) => Str::contains($i,'bower_components/datatables-buttons/js/buttons.print.js'))
        ->toArray(true);
    $filter = array_keys($filter);
    $index = $filter[0];

    $lines->insert($index + 1,'<?= $html->scriptLink("assets/js/custom/datatables/datatables.uikit.js", "Admin") ?>');

    $newContents = implode(PHP_EOL,$lines->toArray());
    $fs->dumpFile($file->getRealPath(),$newContents);
    var_dump($file->getRealPath());
    exit(0);


}

var_dump("ok");
exit(0);

$codes = <<<PHP
<?= \$html->scriptLink("bower_components/pdfmake/build/vfs_fonts.js", "Admin") ?>
<?= \$html->scriptLink("bower_components/datatables-buttons/js/buttons.colVis.js", "Admin") ?>
<?= \$html->scriptLink("bower_components/datatables-buttons/js/buttons.html5.js", "Admin") ?>
<?= \$html->scriptLink("bower_components/datatables-buttons/js/buttons.print.js", "Admin") ?>
<?= \$html->scriptLink("assets/js/custom/datatables/datatables.uikit.js", "Admin") ?>

PHP;


$alist = new ArrayList(explode(PHP_EOL,$codes));
$filterd = $alist->where(fn($i) => Str::contains($i,"bower_components/datatables-buttons/js/buttons.print.js"))
    ->toArray(true);
if(!empty($filterd)){
    $filterd = array_keys($filterd);
    $filterd = $filterd[0];
}
$alist->insert($filterd + 1,"deneme");
var_dump($alist->toArray());
exit(0);




$r = new ReflectionClass(ClassField::class);



//$cls = CodeFactory::createFromReflection($r,true);
$cls = CodeFactory::classCreate("Test");

$c1 = '\Gek\Tools\Xml\Node';
$c2 = '\Gek\View\Html\Node';

$p1 = $cls->addProperty("xNode",$c1);
$p2 = $cls->addProperty("hNode",$c2);
$cls->syncUses();
$p1->autoDocComment();
$p2->autoDocComment();


//$cls = CodeFactory::classCreateFromFile('D:\Gek_Framework\packages\phplang\phplang\DeliveryDatesController.php');

file_put_contents("strrr.php", "<?php" . PHP_EOL . $cls->toIndentedString());
exit(0);

$src = 'C:\tools\mpgh\mpgh\dts\inc\data';
$files = FileFinder::create()
    ->onlyFiles()
    ->in($src)
    ->asEnumerable()
    ->toGroupedArray(fn(FileInfo $fi) => $fi->getSize() . "");
$files = Enumerable::fromArray($files)
    ->where(fn(array $f) => count($f) > 1)
    ->toArray(true);
$hashArr = array();
foreach ($files as $size => $flArr) {
    /** @var FileInfo $filePath */
    foreach ($flArr as $filePath) {
        $h = hash_file('md5', $filePath->getRealPath());
        if (!isset($hashArr[$h])) {
            $hashArr[$h] = array();
        }
        $hashArr[$h][] = $filePath;
    }
}
$totalsize = 0;
$deleteSize = 0;
$deleteFileArr = new ArrayList();
$kalanSize = 0;
foreach ($hashArr as $fileArr) {
    $cArr = Enumerable::fromArray($fileArr)
        ->orderByDesc(fn(FileInfo $fi) => $fi->getFilename())
        ->toArray();
    $totalsize += Enumerable::fromArray($cArr)
        ->sum(fn(FileInfo $fi) => $fi->getSize());
    $first = array_shift($cArr);
    $kalanSize += $first->getSize();
    $deleteSize += Enumerable::fromArray($cArr)
        ->sum(fn(FileInfo $fi) => $fi->getSize());
    $deleteFileArr->addRange($cArr);
}

$deleteFileArr = $deleteFileArr
    ->select(fn(FileInfo $fi) => $fi->getRealPath())
    ->toArray();

$fs = new Filesystem();
$fs->removeAll($deleteFileArr);


var_dump($deleteFileArr);
var_dump(count($deleteFileArr));
var_dump($deleteSize);
var_dump($deleteSize / 1024 / 1024 / 1024);
var_dump($totalsize);
var_dump($totalsize / 1024 / 1024 / 1024);
var_dump($kalanSize);
var_dump($kalanSize / 1024 / 1024 / 1024);
exit(0);


class PropertyVisitor extends NodeVisitorAbstract
{

    protected string $propertyName;


    protected ?string $foundMethodBody = null;

    public function __construct($propertyName)
    {
        $this->propertyName = $propertyName;
    }

    public function leaveNode($node)
    {
        if ($node instanceof \PhpParser\Node\Stmt\PropertyProperty) {
            if ($node->name->toString() == $this->propertyName) {
                $prettyPrinter = new \PhpParser\PrettyPrinter\Standard();
                $body = $prettyPrinter->prettyPrint([$node->default]);
                var_dump($body);

            }

        }
    }

    public function getMethodBody(): ?string
    {
        return $this->foundMethodBody;
    }

}

class CommentVisitor extends NodeVisitorAbstract
{


    public function __construct()
    {

    }

    public function leaveNode($node)
    {
        if (!empty($node->getAttribute("comments"))) {

            foreach ($node->getAttribute("comments") as $comment) {
                $text = Str::toLowerCase($comment->getText());


                $isComm = false == Str::startsWith($text, "#region");
                if ($isComm) {
                    $isComm = false == Str::startsWith($text, "#endregion");
                }
                if ($isComm) {
                    $isComm = false == Str::startsWith($text, "/**");
                }

                if ($isComm) {
                    var_dump($comment);
                }


            }
        }
    }


}

$fiie = 'D:\Gek_Framework\packages\phplang\phplang\DeliveryDatesController.php';
$source = file_get_contents($fiie);

$parser = (new ParserFactory)->create(ParserFactory::PREFER_PHP7);


$ast = $parser->parse($source);
$traverser = new NodeTraverser;
// $flag = false;
$visitor = new PropertyVisitor("filledArray");
$traverser->addVisitor($visitor);
$visitor2 = new CommentVisitor();
//$traverser->addVisitor($visitor2);
$traverser->traverse($ast);

var_dump("ok");