<?php
namespace Catalog\Views\Admin\Brands;

use Catalog\Controllers\Admin\BrandsController;

/** @var \CodeIgniter\View\View|\GekTools\Tools\View\GekView $this */
/** @var \Catalog\ModelData\Admin\Brands\BrandSearchModelData $modelData */
/** @var \Catalog\ModelData\Admin\Brands\BrandSearchModelData $fi */
$fi = \Gek\Infrastructure\ClassHelper::getMetaObject($modelData);
/** @var \GekTools\Tools\View\PageData $pageData */
/** @var \GekTools\Tools\Routing\UrlHelper $url */
/** @var \GekTools\Tools\View\Html $html */
$this->extend('App\Views\Admin\Shared\DefaultLayout');
$pageData->setActiveMenuName('AdminBrand');
?>

<?= $this->section('headBottom') ?>
<!--- head kısmı css vsr.. -->
<?= $this->endSection() ?>
<?= $this->section('body') ?>
<div id="page_content_inner">
    <h3 class="heading_b uk-margin-bottom">Marka</h3>
    <div class="md-card">
        <div class="md-card-content">
            <div class="uk-grid" data-uk-grid-margin>
                <div class="uk-width-medium-1-2">
                    <?= $html->labelFor($modelData,$fi->searchTerm) ?>
                    <?= $html->editorFor($modelData,$fi->searchTerm,['class' => "md-input" ]) ?>
                </div>
                <div class="uk-width-medium-1-2">
                    <button id="search-list" type="button" class="md-btn md-btn-primary">Ara</button>
                </div>
            </div>
        </div>
    </div>
    <div class="mb-card">
        <div class="md-card-content">
            <div class="dt_colVis_buttons"></div>
            <table id="list-table" class="uk-table" cellspacing="0" width="100%">
                <thead>
                <tr>
                    <th>Id</th>
                    <th>Resmi</th>
                    <th>Ad</th>
                    <th>Yayında</th>
                    <th>Oluşturma Tarihi</th>
                    <th>İşlemler</th>
                </tr>
                </thead>
                <tbody>
                </tbody>
            </table>
        </div>
        <script>
            var listOptions = {
                gridSelector: "#list-table",
                searchButtonSelector: '#search-list',
                searchFieldsSelector: "#<?= $fi->searchTerm ?>",
                readUrl: "<?= $url->actionUrl(BrandsController::class, 'listPost', [], 0, 'post') ?>",
                updateUrl: "<?= $url->actionUrlFormat(BrandsController::class, 'edit', ['(:num)']) ?>",
                deleteUrl: "<?= $url->actionUrl(BrandsController::class, 'deletePost') ?>",
                languageFileUrl: "<?= $url->resolvePublicUrl("/bower_components/datatables/media/i18n/Turkish.json", "Admin") ?>",
            };
        </script>
    </div>
</div>
<div class="md-fab-wrapper">
    <a class="md-fab md-fab-accent" href="<?= $url->actionUrl(BrandsController::class, 'add') ?>" id="recordAdd">
        <i class="material-icons">add</i>
    </a>
</div>
<?= $this->endSection() ?>
<?= $this->section('scriptsBottom') ?>
<!-- datatables -->

<!-- datatables buttons-->




<?= $html->scriptLink("bower_components/datatables/media/js/jquery.dataTables.min.js", "Admin") ?>

<!-- datatables buttons-->
<?= $html->scriptLink("bower_components/datatables-buttons/js/dataTables.buttons.js", "Admin") ?>
<?= $html->scriptLink("bower_components/jszip/dist/jszip.min.js", "Admin") ?>
<?= $html->scriptLink("bower_components/pdfmake/build/pdfmake.min.js", "Admin") ?>
<?= $html->scriptLink("bower_components/pdfmake/build/vfs_fonts.js", "Admin") ?>
<?= $html->scriptLink("bower_components/datatables-buttons/js/buttons.colVis.js", "Admin") ?>
<?= $html->scriptLink("bower_components/datatables-buttons/js/buttons.html5.js", "Admin") ?>
<?= $html->scriptLink("bower_components/datatables-buttons/js/buttons.print.js", "Admin") ?>
<?= $html->scriptLink("assets/js/custom/datatables/datatables.uikit.js", "Admin") ?>
<!-- datatables custom integration -->
<?= $html->scriptLink("admin/assets/js/pages/brands/brands_list.js", "Admin") ?>

<?= $this->endSection() ?>
