<?php


namespace Gek\PhpLang\Traits;


trait RegionAware
{

    #region fields

    protected ?string $region = null;

    #endregion fields

    #region properties

    /**
     * @return string|null
     */
    public function getRegion():?string {
        return $this->region;
    }

    /**
     * @param string|null $region
     * @return self
     */
    public function setRegion(?string $region):self {
        $this->region = $region;
        return $this;
    }

    public function hasRegion():bool {
        return $this->region !== null;
    }

    #endregion properties

}
