<?php


namespace Gek\PhpLang\Collections;


use Gek\Collections\ArrayList;
use Gek\Collections\TypedListWrapper;
use Gek\PhpLang\DocComments\DocCommentTag;

class DocCommentTagCollection extends TypedListWrapper implements \Serializable
{
    #region ctor

    /**
     * IntList constructor.
     * @param DocCommentTag ...$items
     */
    public function __construct(DocCommentTag ...$items)
    {
        parent::__construct(new ArrayList(), DocCommentTag::class);
        $this->addRange(...$items);
    }

    #endregion ctor

    #region methods

    /**
     * @param DocCommentTag $item
     */
    public function add(DocCommentTag $item):void{
        $this->innerList->add($item);
    }

    /**
     * @param DocCommentTag ...$items
     */
    public function addRange(DocCommentTag ...$items):void{
        $this->innerList->addRange($items);
    }



    /**
     * @param DocCommentTag $item
     * @return bool
     */
    public function contains(DocCommentTag $item):bool{
        return $this->innerList->contains($item);
    }

    /**
     * @param DocCommentTag  $item
     * @return bool
     */
    public function remove(DocCommentTag $item):bool{
        return $this->innerList->remove($item);
    }

    /**
     * @param DocCommentTag $item
     * @return int
     */
    public function indexOf(DocCommentTag $item): int{
        return $this->innerList->indexOf($item);
    }

    /**
     * @param int $index
     * @param DocCommentTag $item
     */
    public function insert(int $index, DocCommentTag $item): void{
        $this->innerList->insert($index,$item);
    }

    /**
     * @param int $index
     * @return DocCommentTag
     */
    public function getAt(int $index):DocCommentTag {
        return $this->innerList[$index];
    }

    /**
     * @param int $index
     * @param DocCommentTag $item
     */
    public function setAt(int $index, DocCommentTag $item):void{
        $this->innerList[$index] = $item;
    }

    /**
     * @param int $index
     * @param DocCommentTag ...$items
     */
    public function insertRange(int $index, DocCommentTag ...$items):void{
        $this->innerList->insertRange($index,$items);
    }

    /**
     * @param string $tag
     * @param string $value
     * @return self
     */
    public function updateTag(string $tag, string $value):self {
        $tg = new DocCommentTag($tag,$value);
        /** @var DocCommentTag[] $lst */
        $lst = $this->where(function (DocCommentTag &$item)use($tg){
            return $item->key == $tg->key;
        })->toArrayList();
        foreach ($lst as  &$itm){
            $itm->value = $value;
        }
        return $this;
    }

    /**
     * @param string $tag
     * @param string $value
     * @return self
     */
    public function addTag(string $tag, string $value = ''):self {
        $tg = new DocCommentTag($tag,$value);
        $this->add($tg);
        return $this;
    }

    /**
     * @param string $tag
     * @param string $value
     * @return self
     */
    public function addOrUpdateTag(string $tag, string $value = ''):self {
        $tg = new DocCommentTag($tag,$value);
        $isSet = $this->any(function (DocCommentTag $item)use($tg){
            return $item->key == $tg->key;
        });
        if($isSet){
            $this->updateTag($tag,$value);
        }else{
            $this->addTag($tag,$value);
        }
        return $this;
    }

    /**
     * @param string $tag
     * @param string|null $value
     * @return bool
     */
    public function containsTag(string $tag, ?string $value = null):bool {
        $tg = new DocCommentTag($tag,$value === null ? '':$value );
        if($value !== null){
            return $this->contains($tg);
        }
        return $this->any(function (DocCommentTag $item)use($tg){
            return $item->key == $tg->key;
        });
    }

    #endregion methods

    #region Serializable

    /**
     * String representation of object
     * @link https://php.net/manual/en/serializable.serialize.php
     * @return string the string representation of the object or null
     * @since 5.1.0
     */
    public function serialize()
    {
        return serialize($this->toArray());
    }

    /**
     * Constructs the object
     * @link https://php.net/manual/en/serializable.unserialize.php
     * @param string $serialized <p>
     * The string representation of the object.
     * </p>
     * @return void
     * @since 5.1.0
     */
    public function unserialize($serialized)
    {
        $data = unserialize($serialized);
        parent::__construct(new ArrayList(), DocCommentTag::class);
        $this->addRange(...$data);
    }

    #endregion Serializable
}
