<?php


namespace Gek\PhpLang;


use Gek\PhpLang\DocComments\DocComment;
use Gek\PhpLang\Traits\DocCommentAware;
use Gek\PhpLang\Traits\MagicGetSetAware;
use Gek\PhpLang\Traits\NameAware;
use Gek\PhpLang\Traits\RegionAware;
use Gek\PhpLang\Traits\VisibilityAware;

abstract class ClassMember
{
    use NameAware;
    use DocCommentAware;
    use VisibilityAware;
    use RegionAware;
    use MagicGetSetAware;

    #region ctor

    /**
     * ClassMember constructor.
     * @param string $name
     * @param PhpVisibility|null $visibility
     */
    public function __construct(string $name, ?PhpVisibility $visibility = null)
    {
        $this->setName($name);
        if($visibility !== null){
            $this->setVisibility($visibility);
        }else{
            $this->setVisibility(PhpVisibility::PUBLIC());
        }
    }

    #endregion ctor

    #region methods

    /**
     * @return array
     */
    protected function getDataForSerialize():array {
        $data = [
            'nm' => $this->name
        ];
        if(!$this->getDocComment()->isEmpty()){
            $data['dc'] = $this->getDocComment();
        }
        if(isset($this->visibility) && $this->visibility->getValue() != PhpVisibility::PUBLIC){
            $data['vs'] = $this->visibility->getValue();
        }
        if($this->hasRegion()){
            $data['rg'] = $this->getRegion();
        }

        return $data;
    }

    /**
     * @param array $data
     * @throws \ReflectionException
     */
    protected function setDataForSerialize(array $data):void {
        $this->setName($data['nm']);
        if(isset($data['dc'])){
            $this->docComment = $data['dc'];
        }else{
            $this->docComment = new DocComment();
        }
        if(isset($data['vs'])){
            $this->visibility = new PhpVisibility($data['vs']);
        }else{
            $this->visibility = PhpVisibility::PUBLIC();
        }
        $this->region = isset($data['rg']) ? $data['rg'] : null;

    }

    #endregion methods

}
