<?php


namespace Gek\PhpLang\Traits;


use Gek\PhpLang\PhpVisibility;

trait VisibilityAware
{
    /**
     * @var PhpVisibility
     */
    protected PhpVisibility $visibility;

    /**
     * @return PhpVisibility
     */
    public function getVisibility():PhpVisibility{
        if(!isset($this->visibility) || empty($this->visibility)){
            $this->visibility = PhpVisibility::PUBLIC();
        }
        return $this->visibility;
    }

    /**
     * @param PhpVisibility $visibility
     * @return self
     */
    public function setVisibility(PhpVisibility $visibility):self {
        $this->visibility = $visibility;
        return $this;
    }

    /**
     * @return self
     */
    public function setPrivate():self {
        $this->visibility = PhpVisibility::PRIVATE();
        return $this;
    }

    /**
     * @return self
     */
    public function setPublic():self {
        $this->visibility = PhpVisibility::PUBLIC();
        return $this;
    }

    /**
     * @return self
     */
    public function setProtected():self {
        $this->visibility = PhpVisibility::PROTECTED();
        return $this;
    }




}