<?php


namespace Gek\PhpLang\Traits;


use Gek\PhpLang\ClassConst;
use Gek\PhpLang\LiteralTypes;

trait ValueAware
{

    #region fields

    /**
     * @var mixed
     */
    protected $value;

    protected int $valueRenderType = LiteralTypes::NONE;

    #endregion fields

    #region properties

    /**
     * @return mixed
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * @param $value
     * @param int|null $renderType
     * @return self
     * @throws \ReflectionException
     * @throws \InvalidArgumentException
     */
    public function setValue($value, ?int $renderType = null): self
    {
        if ($renderType !== null) {
            $this->setValueRenderType($renderType);
        }
        $this->value = $value;
        return $this;
    }

    /**
     * @return int
     */
    public function getValueRenderType(): int
    {
        return $this->valueRenderType;
    }

    /**
     * @param int $valueRenderType
     * @return self
     * @throws \ReflectionException
     * @throws \InvalidArgumentException
     */
    public function setValueRenderType(int $valueRenderType): self
    {
        if (!LiteralTypes::checkEnumValue($valueRenderType)) {
            throw new \InvalidArgumentException('$valueRenderType (' . $valueRenderType . ') LiteralTypes değerlerinin dışında.');
        }
        $this->valueRenderType = $valueRenderType;
        return $this;
    }


    #endregion properties

    #region methods

    /**
     * @return bool
     */
    public function isSetValue():bool {
        return isset($this->value);
    }

    #endregion methods

}