<?php


namespace Gek\PhpLang\Traits;


use Gek\PhpLang\DocComments\DocComment;
use Gek\PhpLang\DocComments\DocCommentTag;

/**
 * Trait DocCommentAware
 * @package Gek\PhpLang\Traits
 */
trait DocCommentAware
{

    protected DocComment $docComment;


    /**
     * @return DocComment
     */
    public function getDocComment():DocComment{
        if(!isset($this->docComment) || empty($this->docComment)){
            $this->docComment = new DocComment();
        }
        return $this->docComment;
    }

    /**
     * @param DocComment $docComment
     * @return self
     */
    public function setDocComment(DocComment $docComment):self {
        $this->docComment = $docComment;

        return $this;
    }

    /**
     * @param DocCommentTag|string $tag
     * @param string|null $value
     * @return self
     */
    public function addCommentTag($tag, ?string $value = null):self {
        $this->getDocComment()->addTag($tag,$value);
        return $this;
    }

    /**
     * @param string $summaryLine
     * @return self
     */
    public function addCommentSummary(string $summaryLine):self {
        $this->getDocComment()->addSummary($summaryLine);
        return $this;
    }

    /**
     * @param string $descriptionLine
     * @return self
     */
    public function addCommentDescription(string $descriptionLine):self {
        $this->getDocComment()->addDescription($descriptionLine);
        return $this;
    }




}