<?php


namespace Gek\PhpLang;


use Gek\Collections\ArrayList;
use Gek\PhpLang\Contracts\IToIndentedString;

class PhpFile implements IToIndentedString
{
    #region fields

    /** @var string|null  */
    protected ?string $namespace = null;

    /** @var ArrayList|IToIndentedString[]  */
    protected ArrayList $contents;

    #endregion fields

    #region ctor

    public function __construct(?string $namespace = null)
    {
        $this->namespace = $namespace;
        $this->contents = new ArrayList();
    }

    #endregion ctor

    #region properties

    /**
     * @return string|null
     */
    public function getNamespace(): ?string
    {
        return $this->namespace;
    }

    /**
     * @param string|null $namespace
     * @return PhpFile
     */
    public function setNamespace(?string $namespace): PhpFile
    {
        $this->namespace = $namespace;
        return $this;
    }

    #endregion properties

    #region methods

    /**
     * @param IToIndentedString|string $content
     * @return $this
     */
    public function addContent($content):self {
        if($content instanceof PhpClass){
            if(empty($this->namespace)){
                $this->namespace = $content->getNamespace();
            }

            $content->setNamespace(null);
        }
        if(is_string($content)){
            $content = new CodeLine($content);
        }
        $this->contents->add($content);
        return $this;
    }

    public function __toString()
    {
        return $this->toIndentedString();
    }



    #endregion methods

    #region IToIndentedString

    public function toIndentedString(int $indentLevel = 0, string $indentChars = '    '): string
    {
        $str = '<?php ' . PHP_EOL;
        if(!empty($this->namespace)){
            $str .= 'namespace ' . $this->getNamespace() . ';' . PHP_EOL;
        }
        foreach ($this->contents as $cnt){
            $str .= $cnt->toIndentedString($indentLevel,$indentChars);
            if($cnt instanceof CodeLine){
                $str .= PHP_EOL;
            }
        }
        return $str;
    }

    #endregion IToIndentedString

}