<?php


namespace Gek\PhpLang;


class CodeFactory
{

    public static function classCreate(string $name): PhpClass
    {
        return self::create($name);
    }

    public static function interfaceCreate(string $name): PhpClass
    {
        return self::create($name,ClassTypes::INTERFACE());
    }

    public static function traitCreate(string $name): PhpClass
    {
        return self::create($name,ClassTypes::TRAIT());
    }

    /**
     * @param string|null $namespace
     * @return PhpFile
     */
    public static function fileCreate(?string $namespace = null):PhpFile{
        return new PhpFile($namespace);
    }

    private static function create(string $name, ?ClassTypes $classType = null):PhpClass{
        return  new PhpClass($name,$classType);
    }

}
