<?php


namespace Gek\PhpLang\Traits;


trait MagicGetSetAware
{
    public function __get($name)
    {
        $result = null;
        $method = 'get'.ucwords($name);
        if (method_exists($this, $method))
        {
            $result = $this->$method();
        }
        return $result;
    }

    public function __set($name, $value)
    {
        $method = 'set'.ucwords($name);
        if (method_exists($this, $method))
        {
            $this->$method($value);
            return $this;
        }
        $this->$name = $value;
        return $this;
    }

}
