<?php

use Gek\Collections\Enumerable;
use Gek\PhpLang\ClassMember;
use Gek\PhpLang\CodeFactory;
use Gek\PhpLang\CodeLine;
use Gek\PhpLang\Collections\CodeLineCollection;
use Gek\PhpLang\Collections\MethodParamCollection;
use Gek\PhpLang\Contracts\IToIndentedString;
use Gek\PhpLang\Contracts\IUseCreator;
use Gek\PhpLang\DocComments\DocComment;
use Gek\PhpLang\MethodParam;
use Gek\PhpLang\PhpTypeDeclared;
use Gek\PhpLang\PhpVisibility;
use Gek\PhpLang\Traits\AbstractAware;
use Gek\PhpLang\Traits\FinalAware;
use Gek\PhpLang\Traits\StaticAware;
use Gek\PhpLang\UseItem;

include_once "vendor\autoload.php";

$params = MethodParam::parseParams('ConnectionInterface &$db = null, ValidationInterface $validation = null');
var_dump($params[0]->__toString());
var_dump($params[1]->__toString());
exit(0);

$test = CodeFactory::classCreate('ClassMethod')
    ->setNamespace("Gek\\PhpLang")
    ->setExtends(ClassMember::class)
    ->addImplement(IToIndentedString::class)
    ->addImplement(IUseCreator::class);
$test->addTrait(StaticAware::class)
    ->addTrait(AbstractAware::class)
    ->addTrait(FinalAware::class)
    ->addUse(PhpVisibility::class)
    ->addUse(UseItem::class)
    ->addUse('Memo\\Code\\MethodParamCollection');

$test->addProperty('interfaceMethod', 'bool',true,false)
    ->setValue('false');
var_dump($test->toIndentedString());
exit(0);


$test->addField('interfaceMethod', 'bool')
    ->setVisibility(PhpVisibility::PROTECTED())
    ->setValue('false')
    ->setRegion('fields')
    ->autoDocComment();

//field
$test->addField('returnType', '?' . PhpTypeDeclared::class)
    ->setVisibility(PhpVisibility::PROTECTED())
    ->setValue('null')
    ->setRegion('fields')
    ->autoDocComment();

$test->addField('params', MethodParamCollection::class)
    ->setVisibility(PhpVisibility::PROTECTED())
    ->setRegion('fields')
    ->autoDocComment();

$test->addField('codeLines', CodeLineCollection::class)
    ->setVisibility(PhpVisibility::PROTECTED())
    ->setRegion('fields')
    ->autoDocComment();

// ctor
$ctor = $test->addConstructor(true)
    ->addParams('string $name, ?PhpVisibility $visibility = null')
    ->setBody('parent::__construct($name, $visibility);
$this->params = new MethodParamCollection();
$this->codeLines = new CodeLineCollection();')
    ->autoDocComment();


// Properties
$test->addMethod('setInterfaceMethod')
    ->addParams('bool $interfaceMethod = true')
    ->setReturnType('self')
    ->setBody('$this->interfaceMethod = $interfaceMethod;
return $this;')
    ->setRegion('Properties')
    ->autoDocComment();

$test->addMethod('getReturnType')
    ->setReturnType('?string')
    ->setBody('return $this->returnType !== null ? $this->returnType->getRaw() : null;')
    ->setRegion('Properties')
    ->autoDocComment();

$test->addMethod('setReturnType')
    ->addParams('PhpTypeDeclared|array|string|null $returnType')
    ->setReturnType('self')
    ->setBody('if (is_array($returnType)) {
    $temp = array();
    foreach ($returnType as $tp) {
        if ($tp === null) {
            $tp = \'null\'; 
        }
        if (empty($tp)) {
            continue;
        }
        $temp[] = $tp;
    }
    $returnType = implode(\'|\', $temp);
}
if (is_string($returnType)) {
    $returnType = new PhpTypeDeclared($returnType);
}
$this->returnType = $returnType;
return $this;')
    ->setRegion('Properties')
    ->autoDocComment()
    ->addCommentTag('throws', '\Gek\Infrastructure\Exceptions\GekException')
    ->addCommentTag('throws', '\ReflectionException');

$test->addMethod('getParams')
    ->setReturnType(MethodParamCollection::class)
    ->setBody('return $this->params;')
    ->setRegion('Properties')
    ->autoDocComment();

$test->addMethod('setParams')
    ->addParams('MethodParamCollection $params')
    ->setReturnType('self')
    ->setBody('$this->params = $params;
    return $this;')
    ->setRegion('Properties')
    ->autoDocComment();

$test->addMethod('getCodeLines')
    ->setReturnType(CodeLineCollection::class)
    ->setBody('return $this->codeLines;')
    ->setRegion('Properties')
    ->autoDocComment();

$test->addMethod('setCodeLines')
    ->addParams('CodeLineCollection $codeLines')
    ->setReturnType('self')
    ->setBody('$this->codeLines = $codeLines;
    return $this;')
    ->setRegion('Properties')
    ->autoDocComment();

$test->addMethod('getBody')
    ->setReturnType('string')
    ->setBody('return strval($this->codeLines);')
    ->setRegion('Properties')
    ->autoDocComment();

$test->addMethod('setBody')
    ->addParams('string $codes')
    ->setReturnType('self')
    ->setBody('$this->codeLines->clear();
    $this->codeLines->addCodes($codes);
    return $this;')
    ->setRegion('Properties')
    ->autoDocComment();

// Methods

$test->addMethod('isInterfaceMethod')
    ->setReturnType('bool')
    ->setBody('return $this->interfaceMethod;')
    ->setRegion('Methods')
    ->autoDocComment();

$test->addMethod('hasParams')
    ->setReturnType('bool')
    ->setBody('$this->params->any();')
    ->setRegion('Methods')
    ->autoDocComment();

$test->addMethod('addParam')
    ->addParams(MethodParam::class . '|string $param, ?string $type = null, ?string $val = null, ?int $renderType = null')
    ->setReturnType('self')
    ->setBody('$this->params->addParam($param, $type, $val, $renderType);
    return $this;')
    ->setRegion('Methods')
    ->autoDocComment()
    ->addCommentTag('throws', '\ReflectionException')
    ->addCommentTag('throws', '\Gek\Infrastructure\Exceptions\GekException');

$test->addMethod('addParams')
    ->addParams('string $params')
    ->setReturnType('self')
    ->setBody('$this->params->addParams($params);
    return $this;')
    ->setRegion('Methods')
    ->autoDocComment()
    ->addCommentTag('throws', '\ReflectionException')
    ->addCommentTag('throws', '\Gek\Infrastructure\Exceptions\GekException');

$test->addMethod('addCodeLine')
    ->addParams(CodeLine::class . '|string $code, int $indentLevel = 0')
    ->setReturnType('self')
    ->setBody('$this->codeLines->addCodeLine($code, $indentLevel);
    return $this;')
    ->setRegion('Methods')
    ->autoDocComment();

$test->addMethod('addCodeLines')
    ->addParams('string $code')
    ->setReturnType('self')
    ->setBody('$this->codeLines->addCodes($code);
    return $this;')
    ->setRegion('Methods')
    ->autoDocComment();

$test->addMethod('hasBody')
    ->setReturnType('bool')
    ->setBody('return $this->codeLines->any();')
    ->setRegion('Methods')
    ->autoDocComment();

$test->addMethod('hasReturnType')
    ->setReturnType('bool')
    ->setBody('return $this->getReturnType() !== null;')
    ->setRegion('Methods')
    ->autoDocComment();

$test->addMethod('autoDocComment')
    ->setReturnType('self')
    ->setBody('$this->getDocComment()->getTags()->clear();
if ($this->params->any()) {
    foreach ($this->params as $prm) {
        $this->addCommentTag(\'param\', $prm->renderForComment());
    }
}
if ($this->hasReturnType()) {
    $this->addCommentTag(\'return\', $this->returnType->renderForComment());
}
return $this;')
    ->setRegion('Methods')
    ->autoDocComment();

$test->addMethod('__toString')
    ->setBody('return $this->toIndentedString();')
    ->setRegion('Methods');

// IToIndentedString
$test->addMethod('toIndentedString')
    ->addParams('int $indentLevel = 0,string $indentChars = \'    \'')
    ->setReturnType('string')
    ->setBody('$indent = str_repeat($indentChars, $indentLevel);

$strRes = \'\';
if(!$this->getDocComment()->isEmpty()){
    $strRes .= $this->getDocComment()->toIndentedString($indentLevel,$indentChars);
}

$strRes .= $indent . $this->visibility->getValue() . " ";
if ($this->isAbstract()) {
    $strRes .= \'abstract \';
} elseif ($this->isFinal()) {
    $strRes .= \'final \';
}
if ($this->isStatic()) {
    $strRes .= \'static \';
}
$strRes .= \'function \'.  $this->getName();
$strRes .= \'(\' . $this->params . ")";
if ($this->hasReturnType()) {
    $retType = $this->returnType->renderForReturn();
    if(!empty($retType)){
        $strRes .= \':\' . $retType . " ";
    }
}

if ($this->isInterfaceMethod() || $this->isAbstract()) {
    $strRes .= \';\';
} else {
    $strRes .= \'{\' . PHP_EOL;

    if ($this->hasBody()) {
        /** @var CodeLineCollection $lines */
        $lines = $this->codeLines->select(function (CodeLine $item) {
            $item->incrementIndentLevel();
            return $item;
            })->toTypedClass(CodeLineCollection::class);
        $strRes .= $lines->toIndentedString($indentLevel,$indentChars);
    }
    $strRes .= $indent . \'}\' . PHP_EOL;

}

return $strRes;')
    ->setRegion('IToIndentedString')
    ->autoDocComment();

$test->addMethod('getUseArray')
    ->setReturnType('array')
    ->setBody('$useArr  = $this->params->getUseArray();
if($this->hasReturnType()){
    $useArr = array_merge($useArr, $this->returnType->getUseArray());
}
return $useArr;')
    ->addCommentTag('return', 'array|UseItem[]')
    ->setRegion('IUseCreator');

$ser = serialize($test);
//var_dump($ser);
/** @var \Gek\PhpLang\PhpClass $unser */
$unser = unserialize($ser);
var_dump($test->toIndentedString() == $unser->toIndentedString());
var_dump($unser->toIndentedString());

//var_dump($unser);
exit(0);

echo $test->toIndentedString();

exit(0);
$test = implode('|', [
    Traversable::class,
    'array',
    'iterable',
    Iterator::class,
    Generator::class,
    'self',
    IteratorAggregate::class,
    'null',
    \Gek\Collections\ArrayList::class,
    Enumerable::class,
    \Gek\Collections\ICollection::class,

]);
$method = new \Gek\PhpLang\ClassMethod('calculate', PhpVisibility::PRIVATE());
$method->setBody('return md5($password);')
    ->setReturnType($test)
    ->addParams('string|int|float $password = \'5\' ')
    ->autoDocComment();
var_dump($method->toIndentedString(3));
var_dump(Enumerable::fromArray($method->getUseArray())->select(function ($i) {
    return $i . '';
})->toArray());
exit(0);

$field = new \Gek\PhpLang\ClassField('name', '?string', PhpVisibility::PROTECTED());
$field->setValue('null');
$field->autoDocComment();
var_dump($field->toIndentedString('    ', 1));
exit(0);

$test = implode('|', [
    Traversable::class,
    'array',
    'iterable',
    Iterator::class,
    Generator::class,
    'self',
    IteratorAggregate::class,
    'null',
    \Gek\Collections\ArrayList::class,
    Enumerable::class,
    \Gek\Collections\ICollection::class,

]);
$td = new PhpTypeDeclared($test);
var_dump($td->renderForComment());
var_dump($td->renderForField());
var_dump(implode(PHP_EOL, $td->getUseItems()));

exit(0);

$m = new \Gek\PhpLang\ClassMethod("test", PhpVisibility::PROTECTED());
$m->setReturnType('self')
    ->setFinal()
    ->addParams('string $type, bool $isNew = false')
    ->addCodeLines('$this->type = $type;')
    ->addCodeLines('$this->new = $isNew;')
    ->addCodeLines('return $this;');

var_dump($m . '');
exit(0);

$clList = new CodeLineCollection();
$raw = <<<EOD
\$indent = '';
        \$resStr = \$indent . "/**" . PHP_EOL;
        \$resStr .= \$indent ." * " . \$this->getSummary();
        \$resStr .= \$indent . " * " . PHP_EOL;
        if(\$this->description != null){
            \$lines = explode(PHP_EOL,\$this->description);
            foreach (\$lines as \$line){
                \$resStr .= \$indent . " * " . \$line . PHP_EOL;
            }
            \$resStr .= \$indent . " * " . PHP_EOL;
        }
        if(\$this->tags->any()){
            foreach (\$this->tags as \$k => \$v){
                \$resStr .= Str::format("{0} * @{1} {2}{3}",\$indent, \$k, \$v, PHP_EOL);
            }
            \$resStr .= \$indent . " * " . PHP_EOL;
        }
        \$resStr .= \$indent . " */ " . PHP_EOL;

        return \$resStr;
EOD;
$clList->addCodes('$indent = \'\';');
$clList->addCodes('$indent = \'\';');
$clList->addCodes("    \$lines = explode(PHP_EOL,\$this->description);");


var_dump($clList . '');


