<?php


namespace Gek\PhpLang\Collections;


use Gek\Collections\ArrayList;
use Gek\Collections\TypedListWrapper;
use Gek\PhpLang\Contracts\IUseCreator;
use Gek\PhpLang\PhpType;
use Gek\PhpLang\UseItem;

class PhpTypeCollection extends TypedListWrapper implements IUseCreator, \Serializable
{

    #region ctor

    /**
     * IntList constructor.
     * @param PhpType ...$items
     */
    public function __construct(PhpType ...$items)
    {
        parent::__construct(new ArrayList(), PhpType::class);
        $this->addRange(...$items);
    }

    #endregion ctor

    #region methods

    /**
     * @param PhpType $item
     */
    public function add(PhpType $item):void{
        $this->innerList->add($item);
    }

    /**
     * @param PhpType ...$items
     */
    public function addRange(PhpType ...$items):void{
        $this->innerList->addRange($items);
    }



    /**
     * @param PhpType $item
     * @return bool
     */
    public function contains(PhpType $item):bool{
        return $this->innerList->contains($item);
    }

    /**
     * @param PhpType  $item
     * @return bool
     */
    public function remove(PhpType $item):bool{
        return $this->innerList->remove($item);
    }

    /**
     * @param PhpType $item
     * @return int
     */
    public function indexOf(PhpType $item): int{
        return $this->innerList->indexOf($item);
    }

    /**
     * @param int $index
     * @param PhpType $item
     */
    public function insert(int $index, PhpType $item): void{
        $this->innerList->insert($index,$item);
    }

    /**
     * @param int $index
     * @return PhpType
     */
    public function getAt(int $index):PhpType {
        return $this->innerList[$index];
    }

    /**
     * @param int $index
     * @param PhpType $item
     */
    public function setAt(int $index, PhpType $item):void{
        $this->innerList[$index] = $item;
    }

    /**
     * @param int $index
     * @param PhpType ...$items
     */
    public function insertRange(int $index, PhpType ...$items):void{
        $this->innerList->insertRange($index,$items);
    }

    #endregion methods

    #region IUseCreator


    /**
     * @return array|UseItem[]
     */
    public function getUseArray(): array
    {
        return $this->where(function (PhpType $item){
            return $item->isUseItem();
        })->select(function (PhpType $item){
            return $item->getUseItem();
        })->toArray();
    }

    #endregion IUseCreator

    #region Serializable

    /**
     * String representation of object
     * @link https://php.net/manual/en/serializable.serialize.php
     * @return string the string representation of the object or null
     * @since 5.1.0
     */
    public function serialize()
    {
        $data = $this->toArray();
        return serialize($data);
    }

    /**
     * Constructs the object
     * @link https://php.net/manual/en/serializable.unserialize.php
     * @param string $serialized <p>
     * The string representation of the object.
     * </p>
     * @return void
     * @since 5.1.0
     */
    public function unserialize($serialized)
    {
        $data =  unserialize($serialized);
        parent::__construct(new ArrayList(), PhpType::class);
        $this->addRange(...$data);
    }

    #endregion Serializable
}
