<?php


namespace Gek\PhpLang\DocComments;


use Gek\Infrastructure\Str;
use Gek\PhpLang\Traits\MagicGetSetAware;

/**
 * Class DocCommentTag
 * @package Gek\PhpLang\DocComments
 * @property string $key
 * @property string $value
 */
class DocCommentTag implements \Serializable
{
    use MagicGetSetAware;

    #region fields

    private string $_key;

    private string $_value;

    #endregion fields

    #region ctor

    public function __construct(string $key,string $value = '')
    {
        $this->setKey($key);
        $this->setValue($value);
    }

    #endregion ctor

    #region properties

    /**
     * @return string
     */
    public function getKey():string {
        return $this->_key;
    }

    public function setKey(string $key):self {
        $key = $this->fixKey($key);
        if($key === ''){
            throw new \InvalidArgumentException('$key boş.');
        }
        $this->_key = $key;
        return $this;
    }

    public function getValue():string {
        return $this->_value;
    }

    public function setValue(string $value):self {
        $this->_value = $value;
        return $this;
    }



    #endregion properties

    #region methods

    public function __toString()
    {
        return trim(Str::format('@{0} {1}',$this->_key,$this->_value));
    }

    #endregion methods

    #region utils

    /**
     * @param string $key
     * @return string
     */
    private function fixKey(string $key):string {
        $key = trim($key);
        $key = str_replace('@','',$key);
        $key = preg_replace("/\n\r\t+/", ' ', $key);
        $key = preg_replace("/\s+/", ' ', $key);
        //$key = preg_replace("/_+/", '_', $key);
        $key = str_replace([' ','_'],'-',$key);
        $key = strtolower($key);
        return $key;
    }
    #endregion utils

    #region Serializable

    /**
     * String representation of object
     * @link https://php.net/manual/en/serializable.serialize.php
     * @return string the string representation of the object or null
     * @since 5.1.0
     */
    public function serialize()
    {
        $data = [
            'k' => $this->_key
        ];
        if($this->_value !== ''){
            $data['v']= $this->_value;
        }
        return serialize($data);
    }

    /**
     * Constructs the object
     * @link https://php.net/manual/en/serializable.unserialize.php
     * @param string $serialized <p>
     * The string representation of the object.
     * </p>
     * @return void
     * @since 5.1.0
     */
    public function unserialize($serialized)
    {
        $data = unserialize($serialized);
        $this->_key = $data['k'];
        if(isset($data['v'])){
            $this->_value = $data['v'];
        }else{
            $this->_value ='';
        }
    }

    #endregion Serializable
}
