<?php


namespace Gek\PhpLang\DocComments;


use Gek\Infrastructure\Str;
use Gek\PhpLang\Traits\MagicGetSetAware;

/**
 * Class DocCommentTag
 * @package Gek\PhpLang\DocComments
 * @property string $key
 * @property string $value
 */
class DocCommentTag
{
    use MagicGetSetAware;

    #region fields

    private string $_key;

    private string $_value;

    #endregion fields

    #region ctor

    public function __construct(string $key,string $value = '')
    {
        $this->setKey($key);
        $this->setValue($value);
    }

    #endregion ctor

    #region properties

    /**
     * @return string
     */
    public function getKey():string {
        return $this->_key;
    }

    public function setKey(string $key):self {
        $key = $this->fixKey($key);
        if($key === ''){
            throw new \InvalidArgumentException('$key boş.');
        }
        $this->_key = $key;
        return $this;
    }

    public function getValue():string {
        return $this->_value;
    }

    public function setValue(string $value):self {
        $this->_value = $value;
        return $this;
    }



    #endregion properties

    #region methods

    public function __toString()
    {
        return trim(Str::format('@{0} {1}',$this->_key,$this->_value));
    }

    #endregion methods

    #region utils

    /**
     * @param string $key
     * @return string
     */
    private function fixKey(string $key):string {
        $key = trim($key);
        $key = str_replace('@','',$key);
        $key = preg_replace("/\n\r\t+/", ' ', $key);
        $key = preg_replace("/\s+/", ' ', $key);
        //$key = preg_replace("/_+/", '_', $key);
        $key = str_replace([' ','_'],'-',$key);
        $key = strtolower($key);
        return $key;
    }
    #endregion utils

}
