<?php


namespace Gek\PhpLang\Collections;


use Gek\Collections\ArrayList;
use Gek\Collections\TypedListWrapper;
use Gek\PhpLang\ClassMethod;
use Gek\PhpLang\Contracts\IUseCreator;
use Gek\PhpLang\MethodParam;
use Gek\PhpLang\PhpTypeDeclared;
use Gek\PhpLang\UseItem;

class MethodParamCollection extends TypedListWrapper implements IUseCreator
{

    #region ctor

    /**
     * IntList constructor.
     * @param MethodParam ...$items
     */
    public function __construct(MethodParam ...$items)
    {
        parent::__construct(new ArrayList(), MethodParam::class);
        $this->addRange(...$items);
    }

    #endregion ctor

    #region methods

    /**
     * @param MethodParam $item
     */
    public function add(MethodParam $item):void{
        $this->innerList->add($item);
    }

    /**
     * @param MethodParam ...$items
     */
    public function addRange(MethodParam ...$items):void{
        $this->innerList->addRange($items);
    }



    /**
     * @param MethodParam $item
     * @return bool
     */
    public function contains(MethodParam $item):bool{
        return $this->innerList->contains($item);
    }

    /**
     * @param MethodParam  $item
     * @return bool
     */
    public function remove(MethodParam $item):bool{
        return $this->innerList->remove($item);
    }

    /**
     * @param MethodParam $item
     * @return int
     */
    public function indexOf(MethodParam $item): int{
        return $this->innerList->indexOf($item);
    }

    /**
     * @param int $index
     * @param MethodParam $item
     */
    public function insert(int $index, MethodParam $item): void{
        $this->innerList->insert($index,$item);
    }

    /**
     * @param int $index
     * @return MethodParam
     */
    public function getAt(int $index):MethodParam {
        return $this->innerList[$index];
    }

    /**
     * @param int $index
     * @param MethodParam $item
     */
    public function setAt(int $index, MethodParam $item):void{
        $this->innerList[$index] = $item;
    }

    /**
     * @param int $index
     * @param MethodParam ...$items
     */
    public function insertRange(int $index, MethodParam ...$items):void{
        $this->innerList->insertRange($index,$items);
    }


    /**
     * @param MethodParam|string $param
     * @param PhpTypeDeclared|array|string|null $type
     * @param string|null $val
     * @param int|null $renderType
     * @throws \ReflectionException
     * @throws \Gek\Infrastructure\Exceptions\GekException
     */
    public function addParam($param, $type = null, ?string $val = null, ?int $renderType = null ) {
        if($param instanceof MethodParam){
            $this->add($param);
        }else{
            $param = new MethodParam($param,$type);
            $param->setValue($val,$renderType);
            $this->add($param);
        }
    }

    /**
     * @param string $params
     * @throws \Gek\Infrastructure\Exceptions\GekException
     * @throws \ReflectionException
     */
    public function addParams(string $params){
        $paramArr = MethodParam::parseParams($params);
        $this->addRange(...$paramArr);
    }

    public function __toString()
    {
        return implode(', ', $this->toArray());
    }

    #endregion methods

    #region IUseCreator

    /**
     * @return array|UseItem[]
     */
    public function getUseArray(): array
    {
        return $this->where(function (MethodParam $item){
            return $item->hasType();
        })->aggregate(function (&$arr, MethodParam $item){
            $arr = array_merge($arr, $item->getUseArray());
        },array());
    }

    #endregion IUseCreator
}
