<?php


namespace Gek\PhpLang;


use Gek\PhpLang\Traits\DocCommentAware;
use Gek\PhpLang\Traits\MagicGetSetAware;
use Gek\PhpLang\Traits\NameAware;
use Gek\PhpLang\Traits\RegionAware;
use Gek\PhpLang\Traits\VisibilityAware;

abstract class ClassMember
{
    use NameAware;
    use DocCommentAware;
    use VisibilityAware;
    use RegionAware;
    use MagicGetSetAware;

    #region ctor

    /**
     * ClassMember constructor.
     * @param string $name
     * @param PhpVisibility|null $visibility
     */
    public function __construct(string $name, ?PhpVisibility $visibility = null)
    {
        $this->setName($name);
        if($visibility !== null){
            $this->setVisibility($visibility);
        }else{
            $this->setVisibility(PhpVisibility::PUBLIC());
        }
    }

    #endregion ctor

}
