<?php


namespace Gek\PhpLang\Traits;


use Gek\PhpLang\ClassConst;
use Gek\PhpLang\LiteralTypes;

/**
 * ValueAware Trait
 *
 * Değer nitelikleri.
 *
 * @package Gek\PhpLang\Traits
 */
trait ValueAware
{

    #region fields

    /**
     * değer
     * @var mixed
     */
    protected $value;

    /**
     * render tipi
     * @var int
     */
    protected int $valueRenderType = LiteralTypes::NONE;

    #endregion fields

    #region properties

    /**
     * Value getter
     * @return mixed değer
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * Value Setter
     * @param mixed $value değer
     * @param int|null $renderType render tipi
     * @return self
     * @throws \ReflectionException
     * @throws \InvalidArgumentException
     */
    public function setValue($value, ?int $renderType = null): self
    {
        if ($renderType !== null) {
            $this->setValueRenderType($renderType);
        }
        $this->value = $value;
        return $this;
    }

    /**
     * Değer render tipini verir.
     * @return int render tipi
     */
    public function getValueRenderType(): int
    {
        return $this->valueRenderType;
    }

    /**
     * değer render tipini set eder.
     * @param int $valueRenderType render tipi
     * @return self
     * @throws \ReflectionException
     * @throws \InvalidArgumentException
     */
    public function setValueRenderType(int $valueRenderType): self
    {
        if (!LiteralTypes::checkEnumValue($valueRenderType)) {
            throw new \InvalidArgumentException('$valueRenderType (' . $valueRenderType . ') LiteralTypes değerlerinin dışında.');
        }
        $this->valueRenderType = $valueRenderType;
        return $this;
    }


    #endregion properties

    #region methods

    /**
     * değer set edilmiş mi?
     * @return bool edilmişse true aksi halde false
     */
    public function isSetValue():bool {
        return isset($this->value);
    }

    #endregion methods

}