<?php


namespace Gek\PhpLang\Traits;

/**
 * StaticAware Trait
 *
 * Static nitelikleri.
 *
 * @package Gek\PhpLang\Traits
 */
trait StaticAware
{
    /**
     * statik
     * @var bool
     */
    protected bool $static = false;


    /**
     * Statik mi?
     * @return bool statikse true değilse false
     */
    public function isStatic():bool{
        return $this->static;
    }

    /**
     * Statik durumunu değiştir.
     * @param bool $static sattik durumu
     * @return self
     */
    public function setStatic(bool $static = true):self {
        $this->static = $static;
        return $this;
    }


}