<?php


namespace Gek\PhpLang\Traits;

/**
 * AbstractAware Trait
 *
 * Soyut nitelikler
 *
 * @package Gek\PhpLang\Traits
 */
trait AbstractAware
{

    /**
     * soyut
     * @var bool
     */
    protected bool $abstract = false;

    /**
     * soyut mu ?
     * @return bool soyutsa true değilse false
     */
    public function isAbstract():bool {
        return $this->abstract;
    }

    /**
     * soyut durumunu değiştir.
     *
     * @param bool $abstract soyut
     * @return self
     */
    public function setAbstract(bool $abstract = true):self {
        $this->abstract = $abstract;
        return $this;
    }

}