<?php


namespace Gek\Infrastructure\Math\DecimalExpressions;


use Gek\Infrastructure\Math\Decimal;

/**
 * DecimalValueExpression sınıfı
 *
 * Değer ifadesi
 * @package Gek\Infrastructure\Math\DecimalExpressions
 * @since 1.5.0
 */
class DecimalValueExpression extends DecimalExpression
{
    /** @var Decimal Değer */
    protected Decimal $value;

    /**
     * DecimalValueExpression yapıcı metod.
     * @param Decimal $value Değer
     */
    public function __construct(Decimal $value)
    {
        $this->value = $value;
    }

    /**
     * @inheritDoc
     */
    public function calculateValue(): Decimal
    {
        return $this->value;
    }
}