<?php /** @noinspection PhpUnhandledExceptionInspection */


namespace Gek\Infrastructure\Math\DecimalExpressions;


use Gek\Infrastructure\Math\Decimal;

/**
 * DecimalSubExpression sınıfı.
 *
 * Çıkarma ifadesi
 * @package Gek\Infrastructure\Math\DecimalExpressions
 * @since 1.5.0
 */
class DecimalSubExpression extends DecimalExpression
{
    /**
     * @var DecimalExpression|null Sol ifade
     */
    public ?DecimalExpression $left;

    /**
     * @var DecimalExpression|null Sağ ifade
     */
    public ?DecimalExpression $right;

    /**
     * DecimalSubExpression yapıcı metod.
     *
     * @param DecimalExpression|null $left Sol ifade
     * @param DecimalExpression|null $right Sağ ifade
     */
    public function __construct(?DecimalExpression $left = null, ?DecimalExpression $right = null)
    {
        $this->left = $left;
        $this->right = $right;
    }

    /**
     * @inheritDoc
     */
    public function calculateValue(): Decimal
    {
        return $this->left->calculateValue()->sub($this->right->calculateValue());
    }
}