<?php


namespace Gek\Infrastructure\Math\DecimalExpressions;


use Gek\Infrastructure\Math\Decimal;

/**
 * DecimalGroupExpression sınıfı
 *
 * Grup (alt) ifade
 *
 * @package Gek\Infrastructure\Math\DecimalExpressions
 * @since 1.5.0
 */
class DecimalGroupExpression extends DecimalExpression
{
    /** @var DecimalExpression Başlangıç ifadesi */
    public DecimalExpression $startExp;

    /**
     * DecimalGroupExpression yapıcı metod.
     *
     * @param DecimalExpression $startExp Başlangıç ifadesi
     */
    public function __construct(DecimalExpression $startExp)
    {
        $this->startExp = $startExp;
    }

    /**
     * @inheritDoc
     */
    public function calculateValue(): Decimal
    {
        return $this->startExp->calculateValue();
    }
}