<?php /** @noinspection PhpUnhandledExceptionInspection */


namespace Gek\Infrastructure\Math\DecimalExpressions;


use Gek\Infrastructure\Math\Decimal;

/**
 * DecimalDivExpression Sınıfı
 *
 * Bölme ifadesi
 *
 * @package Gek\Infrastructure\Math\DecimalExpressions
 * @since 1.5.0
 */
class DecimalDivExpression extends DecimalExpression
{
    /** @var DecimalExpression|null sol ifade */
    public ?DecimalExpression $left;
    /** @var DecimalExpression|null sağ ifade */
    public ?DecimalExpression $right;

    /**
     * DecimalDivExpression yapıcı metod.
     *
     * @param DecimalExpression|null $left sol ifade
     * @param DecimalExpression|null $right sağ ifade
     */
    public function __construct(?DecimalExpression $left = null, ?DecimalExpression $right = null)
    {
        $this->left = $left;
        $this->right = $right;
    }


    /**
     * @inheritDoc
     */
    public function calculateValue(): Decimal
    {
        return $this->left->calculateValue()->div($this->right->calculateValue());
    }
}