<?php /** @noinspection PhpUnhandledExceptionInspection */


namespace Gek\Infrastructure\Math\DecimalExpressions;


use Gek\Infrastructure\Math\Decimal;

/**
 * DecimalAddExpression Sınıfı
 *
 * Decimal toplama ifadesi
 *
 * @package Gek\Infrastructure\Math\DecimalExpressions
 * @since 1.5.0
 */
class DecimalAddExpression extends DecimalExpression
{
    /** @var DecimalExpression|null sol ifade */
    public ?DecimalExpression $left;

    /** @var DecimalExpression|null sağ ifade */
    public ?DecimalExpression $right;

    /**
     * DecimalAddExpression yapıcı metod.
     *
     * @param DecimalExpression|null $left sol ifade
     * @param DecimalExpression|null $right sağ ifade
     */
    public function __construct(?DecimalExpression $left = null, ?DecimalExpression $right = null)
    {
        $this->left = $left;
        $this->right = $right;
    }

    /**
     * @inheritDoc
     */
    public function calculateValue(): Decimal
    {
        return $this->left->calculateValue()->add($this->right->calculateValue());
    }
}