<?php


namespace Gek\Infrastructure\FlagExp;


/**
 * BitwiseNotExpression sınıfı
 *
 * Bitsel "değil" ifadesi
 *
 * @package Gek\Infrastructure\Enums
 */
class BitwiseNotExpression extends FlagExpression
{
    /**
     * @var FlagExpression|null Sağ ifade
     */
    public ?FlagExpression $right;

    /**
     * BitwiseNotExpression yapıcı metod.
     * @param FlagExpression|null $right Sağ ifade
     */
    public function __construct(?FlagExpression $right = null)
    {
        $this->right = $right;
    }

    /**
     * @inheritDoc
     */
    public function calculateValue(): int
    {
        return ~$this->right->calculateValue();
    }
}
