<?php


namespace Gek\Infrastructure;


use ReflectionException;

/**
 * FlagEnum Sınıfı
 * @package Gek\Infrastructure\Enums
 * @since 1.3.0
 */
abstract class FlagEnum extends Enum
{

    /**
     * Bütün bayrakların (flag) or ile birleştirilmiş halini döndürür.
     *
     * @return int
     * @throws ReflectionException
     */
    public static function allFlags(): int
    {
        $flags = parent::getEnumValues();
        $all = 0;
        foreach ($flags as $flag) {
            $all |= $flag;
        }
        return $all;
    }

}
