<?php


namespace Gek\Infrastructure\Exceptions;


use Throwable;

/**
 * InvalidArgumentException sınıfı
 *
 * Geçersiz argüman (parametre) istisnası
 *
 * @package Gek\Infrastructure\Exceptions
 */
class InvalidArgumentException extends \InvalidArgumentException implements IInvalidArgumentException
{
    /**
     * @var string|null argüman (parametre) adı
     */
    private ?string $argumentName;

    /**
     * GekException yapıcı metod.
     *
     * @param string $message hata mesajı
     * @param int $code hata kodu
     * @param Throwable|null $previous alt istisna
     * @param string|null $argumentName Argüman (parametre) adı
     */
    public function __construct($message = "", $code = 0, Throwable $previous = null, ?string $argumentName = null)
    {
        $this->argumentName = $argumentName;
        parent::__construct($message, $code, $previous);
    }

    /**
     * @inheritDoc
     * @since 1.1.0
     */
    public function getArgumentName(): ?string
    {
        return $this->argumentName;
    }

}
