<?php //common
use Gek\Infrastructure\ConstClassType;

include_once __DIR__ . "/../../../../vendor/autoload.php";

?>
# \Gek\Infrastructure\ConstClassType::getValue() kullanımı

**Nesneni tuttuğu değeri döndürür.**

## Basit Kullanım

**örnek 1:**
<?php
/**
 * Class UpdateFrequency
 * @package Seo\Sitemap
 * @method static self ALWAYS()
 * @method static self HOURLY()
 * @method static self DAILY()
 * @method static self WEEKLY()
 * @method static self MONTHLY()
 * @method static self YEARLY()
 * @method static self NEVER()
 */
class UpdateFrequency extends ConstClassType
{

    /**
     * @label Her Zaman
     */
    public const ALWAYS = "always";

    /**
     * @label Saatlik
     */
    public const HOURLY = "hourly";

    /**
     * @label Günlük
     */
    public const DAILY = "daily";

    /**
     * @label Haftalık
     */
    public const WEEKLY = "weekly";

    /**
     * @label Aylık
     */
    public const MONTHLY = "monthly";

    /**
     * @label Yıllık
     */
    public const YEARLY = "yearly";

    /**
     * @label Statik
     */
    public const NEVER = "never";

}

$never = UpdateFrequency::NEVER();

var_dump($never->getValue()); //string(5) "never"
