# \Gek\Infrastructure\Str::detectEncoding() kullanımı

**Verilen metnin karakter kodlamasını bulmaya çalışır.**

## Basit Kullanım

**örnek 1:**
```php
use Gek\Infrastructure\Str;

include_once __DIR__ . "/../../../../vendor/autoload.php";

$utf16 = Str::convertEncoding("Atakan Çalışkan","UCS-2");

var_dump(Str::detectEncoding($utf16,"UCS-2,UTF-7,UTF-8,ASCII")); // string(5) "UCS-2"

var_dump(Str::detectEncoding(Str::convertEncoding("Atakan","UTF-7"),"UCS-2,UTF-7,UTF-8,ASCII")); //string(5) "UTF-7"

var_dump(Str::detectEncoding("Atakan Çalışkan","UCS-2,UTF-7,UTF-8,ASCII")); //string(5) "UTF-8"

var_dump(Str::detectEncoding("Atakan Çalışkan","UCS-2,ASCII,UTF-7,UTF-8")); //string(5) "UTF-8"

var_dump(Str::detectEncoding("Ata","UCS-2,ASCII,UTF-7,UTF-8")); //string(5) "ASCII"

$japonText = chr(0xa5) . chr(0xef) .  chr(0xa5) . chr(0xf5);

var_dump(Str::detectEncoding($japonText,"UCS-2,EUC-JP,ASCII,UTF-7,UTF-8")); //string(6) "EUC-JP"

var_dump($japonText); // string(4) ""
var_dump(Str::convertEncoding($japonText,"UTF-8","EUC-JP")); //string(6) "ワヵ"
```