# \Gek\Infrastructure\IToInt kullanımı

**IToInt Arayüzü**
tam sayıya çevrilebilir türler için arayüz.
## Basit Kullanım

**örnek 1:**
```php
use Gek\Infrastructure\IToInt;

include_once __DIR__ . "/../../../../vendor/autoload.php";


function dump(IToInt $toInt)
{
    var_dump($toInt->toInt());
}

class Age implements IToInt
{

    protected DateTime $birthDate;

    public function __construct(DateTime $birthDate)
    {
        $this->birthDate = $birthDate;
    }

    public function getBirthDate(): DateTime
    {
        return $this->birthDate;
    }

    public function __toString()
    {
        return $this->birthDate->format("d.m.Y");
    }

    public function toInt(): int
    {
        $now = new DateTime("now");
        $diff = $this->birthDate->diff($now);
        $age = (int)$diff->format('%y');
        return $age;
    }

}

class RgbColor implements IToInt
{

    protected int $red;

    protected int $green;

    protected int $blue;

    public function __construct(int $r, int $g, int $b)
    {
        $this->red = $this->fixByteValue($r);
        $this->green = $this->fixByteValue($g);
        $this->blue = $this->fixByteValue($b);
    }

    protected function fixByteValue(int $value): int
    {
        if ($value < 0) {
            return 0;
        }
        if ($value > 255) {
            return 255;
        }
        return $value;
    }

    public function __toString()
    {
        return sprintf("#%02x%02x%02x", $this->red, $this->green, $this->blue);
    }


    public function toInt(): int
    {
        $res = (int)(($this->red) & 0xFF);
        $res = (int)(($res << 8) | ($this->green & 0xFF));
        $res = (int)(($res << 8) | ($this->blue & 0xFF));
        return $res;
    }
}

class CmykColor implements IToInt
{

    protected int $cyan;

    protected int $magenta;

    protected int $yellow;


    protected int $key;

    public function __construct(int $c, int $m, int $y, int $k)
    {
        $this->cyan = $this->fixValue($c);
        $this->magenta = $this->fixValue($m);
        $this->yellow = $this->fixValue($y);
        $this->key = $this->fixValue($k);

    }

    protected function fixValue(int $value): int
    {
        if ($value < 0) {
            return 0;
        }
        if ($value > 100) {
            return 100;
        }
        return $value;
    }

    public function __toString()
    {
        return "cmyk(". implode(',', [$this->cyan,$this->magenta,$this->yellow,$this->key]) . ")";
    }


    public function toInt(): int
    {
        $res = (int)(($this->cyan) & 0xFF);
        $res = (int)(($res << 8) | ($this->magenta & 0xFF));
        $res = (int)(($res << 8) | ($this->yellow & 0xFF));
        $res = (int)(($res << 8) | ($this->key & 0xFF));
        return $res;
    }
}

$myAge = new Age(DateTime::createFromFormat("d.m.Y", "24.09.1981"));

$myRgb = new RgbColor(100,100,100);
$myCmyk = new CmykColor(80,80,80,100);

dump($myRgb); // int(6579300)
dump($myCmyk); // int(1347440740)



```


#### Methods (yöntemler)

| Method (yöntem) | Açıklama |
|---            |---       |
| [toInt](toInt_method.md) |  |
