# \Gek\Infrastructure\ConstClass::getConstDocCommentObjects() kullanımı

**Sabitlerin DocCommentlerini dizi olarak verir.**

## Basit Kullanım

**örnek 1:**
```php
use Gek\Infrastructure\ConstClass;

include_once __DIR__ . "/../../../../vendor/autoload.php";

class SystemRoleNames extends ConstClass
{

    /**
     * @label Yöneticiler
     */
    const ADMINISTARATORS = 'Administrators';

    /**
     * @label Sistem Yöneticileri
     */
    const SYSTEM_ADMIN = 'SystemAdministrators';

    /**
     * @label Kayıtlı kullanıcılar
     */
    const REGISTERED = 'Registered';

    /**
     * @label Misafirler
     */
    const GUESTS = 'Guests';

}

$docComArray = SystemRoleNames::getConstDocCommentObjects();

var_dump($docComArray);
/*
 array(4) {
  'ADMINISTARATORS' =>
  class Gek\Infrastructure\Reflections\DocCommentObject#8 (4) {
    protected ?string $rawDocComment =>
    string(40) "/**
     * @label Töneticiler
     *\/"
    protected array $summaryLines =>
    array(0) {
    }
    protected array $comments =>
    array(0) {
    }
    protected array $keys =>
    array(1) {
      'label' =>
      string(12) "Töneticiler"
    }
  }
  'SYSTEM_ADMIN' =>
  class Gek\Infrastructure\Reflections\DocCommentObject#9 (4) {
    protected ?string $rawDocComment =>
    string(48) "/**
 * @label Sistem Yöneticileri
 *\/"
    protected array $summaryLines =>
    array(0) {
    }
    protected array $comments =>
    array(0) {
    }
    protected array $keys =>
    array(1) {
      'label' =>
      string(20) "Sistem Yöneticileri"
    }
  }
  'REGISTERED' =>
  class Gek\Infrastructure\Reflections\DocCommentObject#10 (4) {
    protected ?string $rawDocComment =>
    string(52) "/**
 * @label Kayıtlı kullanıcılar
 *\/"
    protected array $summaryLines =>
    array(0) {
    }
    protected array $comments =>
    array(0) {
    }
    protected array $keys =>
    array(1) {
      'label' =>
      string(24) "Kayıtlı kullanıcılar"
    }
  }
  'GUESTS' =>
  class Gek\Infrastructure\Reflections\DocCommentObject#11 (4) {
    protected ?string $rawDocComment =>
    string(38) "/**
 * @label Misafirler
 *\/"
    protected array $summaryLines =>
    array(0) {
    }
    protected array $comments =>
    array(0) {
    }
    protected array $keys =>
    array(1) {
      'label' =>
      string(10) "Misafirler"
    }
  }
}
 */


// label array oluşturma
$labelArray = array();

foreach ($docComArray as $contKey => $docComObj ){
    $label = $docComObj->getKey("label");
    if(empty($label)){
        $label = $contKey;
    }
    $labelArray[$contKey] = $label;
}

var_dump($labelArray);
/*
array(4) {
  'ADMINISTARATORS' =>
  string(12) "Yöneticiler"
  'SYSTEM_ADMIN' =>
  string(20) "Sistem Yöneticileri"
  'REGISTERED' =>
  string(24) "Kayıtlı kullanıcılar"
  'GUESTS' =>
  string(10) "Misafirler"
}
 */
```