# \Gek\Infrastructure\ClassHelper::reflectObject() kullanımı

**Verilen nesneni yansımasını (reflection) döndürür.**

## Basit Kullanım

**örnek 1:**
```php
use Gek\Infrastructure\ClassHelper;

include_once __DIR__ . "/../../../../vendor/autoload.php";

$stdObj  = (object)[
        'propA' => 15,
    'propB' => 20,
    'propC' => "asdasd"
];

$reflect = ClassHelper::reflectObject($stdObj);

var_dump($reflect);
/*
class ReflectionObject#2 (1) {
  public $name =>
  string(8) "stdClass"
}
 */

var_dump($reflect->getProperties());
/*
array(3) {
  [0] =>
  class ReflectionProperty#4 (2) {
    public $name =>
    string(5) "propA"
    public $class =>
    string(8) "stdClass"
  }
  [1] =>
  class ReflectionProperty#5 (2) {
    public $name =>
    string(5) "propB"
    public $class =>
    string(8) "stdClass"
  }
  [2] =>
  class ReflectionProperty#6 (2) {
    public $name =>
    string(5) "propC"
    public $class =>
    string(8) "stdClass"
  }
}
 */

```