# \Gek\Infrastructure\ClassHelper::getMetaObjectClassName() kullanımı

**Verilen sınıf adında meta bilgilerini tutan nesne oluşturur.**

## Basit Kullanım

**örnek 1:**
```php
use Gek\Infrastructure\ClassHelper;

include_once __DIR__ . "/../../../../vendor/autoload.php";

class SampleClass{
    public string $propA = "azdcxz";

    public int $propB = 15;

    public float $propC = 5.56;
}

$metaObject = ClassHelper::getMetaObjectClassName(SampleClass::class);

var_dump($metaObject);
/*
class stdClass#6 (3) {
  public $propA =>
  string(5) "propA"
  public $propB =>
  string(5) "propB"
  public $propC =>
  string(5) "propC"
}
 */

var_dump($metaObject->propA); // string(5) "propA"

```