---
title: \Gek\Infrastructure\Str
footer: false
---

# Str

Str sınıfı

Çeşitli metin işleme işlemleri için yardımcı sınıf.
Çeşitli metin işleme işlemleri

örnek: [Str](../../../examples/Gek/Infrastructure/Str_class/index.md)


* Full name (Tam Adı): `\Gek\Infrastructure\Str`

**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/Str_class/index.md)



## Constants (Sabitler)

| Constant | Type | Value |
|:---      |:---  |:---   |
|`\Gek\Infrastructure\Str::FORMAT_START_CHAR`|string|&#039;{&#039;|
|`\Gek\Infrastructure\Str::FORMAT_END_CHAR`|string|&#039;}&#039;|
|`\Gek\Infrastructure\Str::FORMAT_DATE_TIME_FORMAT`||&#039;Y-m-d H:i:s&#039;|
|`\Gek\Infrastructure\Str::CASE_UPPER`||MB_CASE_UPPER|
|`\Gek\Infrastructure\Str::CASE_LOWER`||MB_CASE_LOWER|
|`\Gek\Infrastructure\Str::CASE_TITLE`||MB_CASE_TITLE|

## Methods (Yöntemler)

### format

Verilen değişkenleri verilen formata göre metne dönüştürür.

```php
public static Str::format(string $format, mixed|array $params): string
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `format` | **string** |  |
| `params` | **mixed|array** |  |


**Return Value (Dönüş değeri):**


string



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/Str_class/format_method.md)


---
### ensureMaximumLength

Verilen metni verilen uzunluğa göre sınırlar.

```php
public static Str::ensureMaximumLength(string $str, int $maxLength, string|null $trimMarker = null, string|null $encoding = null): string
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `str` | **string** | Kısaltılacak metin |
| `maxLength` | **int** | Azami uzunluk |
| `trimMarker` | **string|null** | (opsiyonel) kısaltılan metne eklenecek karakterler örn. &gt;&gt;Devamı |
| `encoding` | **string|null** | (opsiyonel) Metin kodlaması örn. UTF-8 |


**Return Value (Dönüş değeri):**

Kısaltılmış metin.
string



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/Str_class/ensureMaximumLength_method.md)


---
### fixSpaces

Verilen metnin boşluklarını düzeltir.

```php
public static Str::fixSpaces(string $str, string $space = &quot; &quot;, bool $onyOneSpace = true, string $convertChars = &quot; 	

 &quot;): string
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `str` | **string** | Metin |
| `space` | **string** | (opsiyonel) boşluk karakteri |
| `onyOneSpace` | **bool** | Çoklu boşlukları teke indir.) |
| `convertChars` | **string** | Boşluk ile değiştirilecek karakterler |


**Return Value (Dönüş değeri):**

Düzeltilmiş metin
string



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/Str_class/fixSpaces_method.md)


---
### toArray

Verilen metni diziye (array) çevirir.

```php
public static Str::toArray(string $str, string|null $encoding = null, int $splitLength = 1): array
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `str` | **string** | Metin |
| `encoding` | **string|null** | (opsiyonel) Metin kodlaması örn. UTF-8 |
| `splitLength` | **int** | (opsiyonel) Bölünen metnin kaç karakter olacağını belirler. Varsayılan : 1 |


**Return Value (Dönüş değeri):**

Bölünmüş metin dizisi
array



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/Str_class/toArray_method.md)


---
### unicodeToEscapedUnicode

Verilen Unicode metni kaçış karakterli metne çevirir.

```php
public static Str::unicodeToEscapedUnicode(string $str, bool $eval = true): string
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `str` | **string** | Unicode metin |
| `eval` | **bool** | eval kullan |


**Return Value (Dönüş değeri):**

Kaçış karakterli metin.
string



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/Str_class/unicodeToEscapedUnicode_method.md)


---
### getDefaultEncoding

Çalışan kodun (php) dahili karakter kodlamasını verir

```php
protected static Str::getDefaultEncoding(): string
```



* Bu yöntem **statiktir**.





**Return Value (Dönüş değeri):**

Dahili karakter kodlaması. Örn. UTF-8
string



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/Str_class/getDefaultEncoding_method.md)


---
### detectEncoding

Verilen metnin karakter kodlamasını bulmaya çalışır.

```php
public static Str::detectEncoding(string $str, string|array|string[]|null $encodingList = null, bool|null $strict = null): false|string
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `str` | **string** | Metin |
| `encodingList` | **string|array|string[]|null** | (opsiyonel) Kodlama listesi |
| `strict` | **bool|null** | (opsiyonel) katı mod |


**Return Value (Dönüş değeri):**

Kodlama bulunursa kodlama bulunamazsa false döndürür
false|string



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/Str_class/detectEncoding_method.md)


---
### checkEncoding

Verilen metinin verilen Encoding ile uyumlu olup olmadığını belirler.

```php
public static Str::checkEncoding(string $str, string $encoding): bool
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `str` | **string** | Metin |
| `encoding` | **string** | Encoding (örn. &#039;UTF-8&#039;) |


**Return Value (Dönüş değeri):**

Metin Encoding ile uyumluysa true değilse false
bool



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/Str_class/checkEncoding_method.md)


---
### convertEncoding

Metnin kodlamasını değiştirir.

```php
public static Str::convertEncoding(string $str, string|null $toEncoding = null, string|null $fromEncoding = null): string
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `str` | **string** | Metin |
| `toEncoding` | **string|null** | (obsiyonel) dönüştürülecek kodlama örn. UTF-8 |
| `fromEncoding` | **string|null** | (opsiyonel) Metnin kodlaması. örn. UTF-8 |


**Return Value (Dönüş değeri):**

Kodlaması dönüştürülmüş metin
string



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/Str_class/convertEncoding_method.md)


---
### startsWith

Bir metnin verilen metin ile başlayıp başlamadığını kontrol eder.

```php
public static Str::startsWith(string $haystack, string $needle, bool $ignoreCaseSensitive = false, string|null $encoding = null, string|null $language = null): bool
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `haystack` | **string** | (samanlık) İçinde arama yapılacak metin |
| `needle` | **string** | (iğne) aranacak metin |
| `ignoreCaseSensitive` | **bool** | (opsiyonel) Küçük/Büyük har duyarlılığını görmezden gel |
| `encoding` | **string|null** | (opsiyonel) Metnin karakter kodlaması örn. UTF-8 |
| `language` | **string|null** | (opsiyonel) Metin dili örn. tr |


**Return Value (Dönüş değeri):**

metin verilen metin ile başlıyorsa true aksi halde false.
bool



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/Str_class/startsWith_method.md)


---
### endsWith

Bir metnin verilen metin ile bitip bitmediğini kontrol eder.

```php
public static Str::endsWith(string $haystack, string $needle, bool $ignoreCaseSensitive = false, string|null $encoding = null, string|null $language = null): bool
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `haystack` | **string** | (samanlık) İçinde arama yapılacak metin |
| `needle` | **string** | (iğne) aranacak metin |
| `ignoreCaseSensitive` | **bool** | (opsiyonel) Küçük/Büyük har duyarlılığını görmezden gel |
| `encoding` | **string|null** | (opsiyonel) Metnin karakter kodlaması örn. UTF-8 |
| `language` | **string|null** | (opsiyonel) Metin dili örn. tr |


**Return Value (Dönüş değeri):**

metin verilen metin ile bitiyorsa true aksi halde false.
bool



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/Str_class/endsWith_method.md)


---
### contains

Bir metnin içinde varilen metin olup olmadığını kontrol eder.

```php
public static Str::contains(string $haystack, string|null $needle, bool $ignoreCaseSensitive = false, string|null $encoding = null, string|null $language = null): bool
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `haystack` | **string** | (samanlık) İçinde arama yapılacak metin |
| `needle` | **string|null** | (iğne) aranacak metin |
| `ignoreCaseSensitive` | **bool** | (opsiyonel) Küçük/Büyük har duyarlılığını görmezden gel |
| `encoding` | **string|null** | (opsiyonel) Metnin karakter kodlaması örn. UTF-8 |
| `language` | **string|null** | (opsiyonel) Metin dili örn. tr |


**Return Value (Dönüş değeri):**

Metnin içinde geçiyorsa true aksi halde false döner
bool



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/Str_class/contains_method.md)


---
### containsCount

Bir metnin içinde varilen metnin kaç kere geçtiğini bulur

```php
public static Str::containsCount(string $haystack, string|null $needle, bool $ignoreCaseSensitive = false, string|null $encoding = null, string|null $language = null): int
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `haystack` | **string** | (samanlık) İçinde arama yapılacak metin |
| `needle` | **string|null** | (iğne) aranacak metin |
| `ignoreCaseSensitive` | **bool** | (opsiyonel) Küçük/Büyük har duyarlılığını görmezden gel |
| `encoding` | **string|null** | (opsiyonel) Metnin karakter kodlaması örn. UTF-8 |
| `language` | **string|null** | (opsiyonel) Metin dili örn. tr |


**Return Value (Dönüş değeri):**

eşleşme sayısı
int



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/Str_class/containsCount_method.md)


---
### indexOf

Bir metnin içinde ki metin parçasının indeksini verir.

```php
public static Str::indexOf(string $haystack, string $needle, bool $ignoreCaseSensitive = false, string|null $encoding = null, string|null $language = null): false|int
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `haystack` | **string** | (Samanlık) İçinde arama yapılacak metin. |
| `needle` | **string** | (iğne) Aranacak metin. |
| `ignoreCaseSensitive` | **bool** | Büyük/Küçük harf ayrımını görmezden gel. |
| `encoding` | **string|null** | (opsiyonel) Metnin Kodlaması örn. UTF-8 |
| `language` | **string|null** | (opsiyonel) Metnin dili örn. tr |


**Return Value (Dönüş değeri):**

Metin bulunursa indeksi bulunamazsa false döner.
false|int



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/Str_class/indexOf_method.md)


---
### lastIndexOf

Bir metnin içinde ki metin parçasının son indeksini verir.

```php
public static Str::lastIndexOf(string $haystack, string $needle, bool $ignoreCaseSensitive = false, string|null $encoding = null, string|null $language = null): false|int
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `haystack` | **string** | (Samanlık) İçinde arama yapılacak metin. |
| `needle` | **string** | (iğne) Aranacak metin. |
| `ignoreCaseSensitive` | **bool** | Büyük/Küçük harf ayrımını görmezden gel. |
| `encoding` | **string|null** | (opsiyonel) Metnin Kodlaması örn. UTF-8 |
| `language` | **string|null** | (opsiyonel) Metnin dili örn. tr |


**Return Value (Dönüş değeri):**

Metin bulunursa son indeksi bulunamazsa false döner.
false|int



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/Str_class/lastIndexOf_method.md)


---
### len

verilen metnin karakter sayısını döndürür.

```php
public static Str::len(string $str, string|null $encoding = null): int
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `str` | **string** | Metin |
| `encoding` | **string|null** | (opsiyonel) metnin karakter kodlaması örn. UTF-8 |


**Return Value (Dönüş değeri):**

Metnin karakter sayısı.
int



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/Str_class/len_method.md)


---
### equals

Verilen metinlerin aynı olup olmadığını karşılaştırır.

```php
public static Str::equals(mixed $str1, mixed $str2, bool $ignoreCaseSensitive = false, bool $strictMode = false, string|null $encoding = null, string|null $language = null): bool
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `str1` | **mixed** | Metin 1 |
| `str2` | **mixed** | Metin 2 |
| `ignoreCaseSensitive` | **bool** | (opsiyonel) Büyük/Küçük harf ayrımı yapma |
| `strictMode` | **bool** | (opsiyonel) katı mode |
| `encoding` | **string|null** | (opsiyonel) Metnin Kodlaması örn. UTF-8 |
| `language` | **string|null** | (opsiyonel) metnin dili örn. tr |


**Return Value (Dönüş değeri):**

Metinler eşitse true değilse false
bool



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/Str_class/equals_method.md)


---
### toLowerCase

Verilen metni küçük harf yapar.

```php
public static Str::toLowerCase(string $str, string|null $encoding = null, string|null $language = null): string
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `str` | **string** | Küçük harf yapılacak metin. |
| `encoding` | **string|null** | (opsiyonel) Metnin kodlaması örn. UTF-8 |
| `language` | **string|null** | (opsiyonel) Metnin dili ör. tr |


**Return Value (Dönüş değeri):**

Küçük harfe çevrilmiş metin.
string



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/Str_class/toLowerCase_method.md)


---
### toUpperCase

Verilen metni büyük harf yapar.

```php
public static Str::toUpperCase(string $str, string|null $encoding = null, string|null $language = null): string
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `str` | **string** | Büyük harf yapılacak metin. |
| `encoding` | **string|null** | (opsiyonel) Metnin kodlaması örn. UTF-8 |
| `language` | **string|null** | (opsiyonel) Metnin dili ör. tr |


**Return Value (Dönüş değeri):**

Büyük harfe çevrilmiş metin.
string



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/Str_class/toUpperCase_method.md)


---
### toTitleCase

Verilen metnin içindeki kelimeleri ilk harflerini büyük harf yapar.

```php
public static Str::toTitleCase(string $str, string|null $encoding = null, string|null $language = null): string
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `str` | **string** | Metin. |
| `encoding` | **string|null** | (opsiyonel) Metnin kodlaması örn. UTF-8 |
| `language` | **string|null** | (opsiyonel) Metnin dili ör. tr |


**Return Value (Dönüş değeri):**

Kelimelerinin ilk harfi büyük yapılmış metin.
string



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/Str_class/toTitleCase_method.md)


---
### ucFirst

Verilen metnin ilk harfini büyük harf yapar.

```php
public static Str::ucFirst(string $str, string|null $encoding = null, string|null $language = null): string
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `str` | **string** | Metin. |
| `encoding` | **string|null** | (opsiyonel) Metnin kodlaması örn. UTF-8 |
| `language` | **string|null** | (opsiyonel) Metnin dili ör. tr |


**Return Value (Dönüş değeri):**

İlk harfi büyük harf yapılmış metin
string



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/Str_class/ucFirst_method.md)


---
### lcFirst

Verilen metnin ilk harfini küçük harf yapar.

```php
public static Str::lcFirst(string $str, string|null $encoding = null, string|null $language = null): string
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `str` | **string** | Metin. |
| `encoding` | **string|null** | (opsiyonel) Metnin kodlaması örn. UTF-8 |
| `language` | **string|null** | (opsiyonel) Metnin dili ör. tr |


**Return Value (Dönüş değeri):**

İlk harfi küçük harf yapılmış metin
string



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/Str_class/lcFirst_method.md)


---
### convertCase

convert case

```php
protected static Str::convertCase(string $str, int $mode, string|null $encoding = null, string|null $language = null): string
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `str` | **string** |  |
| `mode` | **int** |  |
| `encoding` | **string|null** |  |
| `language` | **string|null** |  |


**Return Value (Dönüş değeri):**


string



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/Str_class/convertCase_method.md)


---


---
> 2022-04-14 tarihinde kaynak kod yorumlarından otomatik olarak oluşturulmuştur.
