---
title: \Gek\Infrastructure\FlagEnumType
footer: false
---

# FlagEnumType

FlagEnumType Sınıfı

Flag Enum yapısını simule eder.

örnek: [FlagEnumType](../../../examples/Gek/Infrastructure/FlagEnumType_class/index.md)


* Full name (Tam Adı): `\Gek\Infrastructure\FlagEnumType`
* Parent class (Üst Sınıf): [\Gek\Infrastructure\FlagEnum](./FlagEnum.md)
* Bu sınıf şu arayüzleri (interface) uygular:  \Gek\Infrastructure\IToInt

**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/FlagEnumType_class/index.md)



## Methods (Yöntemler)

### __construct

FlagEnumType yapıcı method

```php
public FlagEnumType::__construct(string|int $value, bool $validateValue = true): mixed
```

.






**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `value` | **string|int** | Bayrak değeri ve ya bayrak adı yada string expression |
| `validateValue` | **bool** | değeri doğrula |


**Return Value (Dönüş değeri):**


mixed



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/FlagEnumType_class/__construct_method.md)


---
### __callStatic



```php
public static FlagEnumType::__callStatic( $name,  $arguments): mixed
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `name` | **** |  |
| `arguments` | **** |  |


**Return Value (Dönüş değeri):**


mixed



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/FlagEnumType_class/__callStatic_method.md)


---
### getValue



```php
public FlagEnumType::getValue(): int
```









**Return Value (Dönüş değeri):**


int



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/FlagEnumType_class/getValue_method.md)


---
### setValue

Bayrak (flag) değerini set eder.

```php
public FlagEnumType::setValue(string|int $value, bool $validateValue = true): void
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `value` | **string|int** | bayrak değeri vaya bayrad adı yada string ifade |
| `validateValue` | **bool** |  |


**Return Value (Dönüş değeri):**


void



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/FlagEnumType_class/setValue_method.md)


---
### toInt

Bayrak (flag) değerini verir.

```php
public FlagEnumType::toInt(): int
```









**Return Value (Dönüş değeri):**

Bayrak değeri
int



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/FlagEnumType_class/toInt_method.md)


---
### __toString

Bayrak (falg) değerinin string expression (ifadesini) verir.

```php
public FlagEnumType::__toString(): string
```









**Return Value (Dönüş değeri):**

Bayrak string expression
string



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/FlagEnumType_class/__toString_method.md)


---


## Inherited methods (kalıtsal yöntemler)

### allFlags

Bütün bayrakların (flag) or ile birleştirilmiş halini döndürür.

```php
public static FlagEnum::allFlags(): int
```



* Bu yöntem **statiktir**.





**Return Value (Dönüş değeri):**


int



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/FlagEnumType_class/allFlags_method.md)


---
### getEnumValue

Enum değerini döndürür.

```php
public static Enum::getEnumValue(string $key): int|null
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `key` | **string** | enum anahtarı (adı) |


**Return Value (Dönüş değeri):**

enum değeri
int|null



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/FlagEnumType_class/getEnumValue_method.md)


---
### getEnumValues

Enum değerlerini dizi olarak döndürür. Enum keu (adı) => enum değeri

```php
public static Enum::getEnumValues(): array|int[]
```



* Bu yöntem **statiktir**.





**Return Value (Dönüş değeri):**

enum değerleri
array|int[]



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/FlagEnumType_class/getEnumValues_method.md)


---
### getConstantsArray



```php
private static Enum::getConstantsArray(string $className): array
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `className` | **string** |  |


**Return Value (Dönüş değeri):**


array



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/FlagEnumType_class/getConstantsArray_method.md)


---
### checkEnumKey

Enum key in mevcut olup olmadığını döndürür.

```php
public static Enum::checkEnumKey(string $key): bool
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `key` | **string** | Enum key (Adı) |


**Return Value (Dönüş değeri):**

Mevcutsa true değilse false
bool



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/FlagEnumType_class/checkEnumKey_method.md)


---
### checkEnumValue

Enum değerinin mevcut olup olmadığını döndürür.

```php
public static Enum::checkEnumValue(int $value): bool
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `value` | **int** | Enum değeri |


**Return Value (Dönüş değeri):**

Değer mevcutsa true değilse false
bool



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/FlagEnumType_class/checkEnumValue_method.md)


---
### getEnumDocComentObjects

Enum sabitlerinin docComment lerinde oluşan bir dizi döndürür.

```php
public static Enum::getEnumDocComentObjects(): array|\Gek\Infrastructure\Reflections\DocCommentObject[]
```



* Bu yöntem **statiktir**.





**Return Value (Dönüş değeri):**


array|\Gek\Infrastructure\Reflections\DocCommentObject[]



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/FlagEnumType_class/getEnumDocComentObjects_method.md)


---


---
> 2022-04-14 tarihinde kaynak kod yorumlarından otomatik olarak oluşturulmuştur.
