---
title: \Gek\Infrastructure\EnumType
footer: false
---

# EnumType

EnumType sınıfı

Enum yapısını simule eder.

örnek: [EnumType](../../../examples/Gek/Infrastructure/EnumType_class/index.md)


* Full name (Tam Adı): `\Gek\Infrastructure\EnumType`
* Parent class (Üst Sınıf): [\Gek\Infrastructure\Enum](./Enum.md)
* Bu sınıf şu arayüzleri (interface) uygular:  \Gek\Infrastructure\IToInt

**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/EnumType_class/index.md)



## Methods (Yöntemler)

### __construct

EnumType yapıcı method

```php
public EnumType::__construct(int|string $value): mixed
```

.






**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `value` | **int|string** | Enum değeri ya da Enum key (adı) |


**Return Value (Dönüş değeri):**


mixed



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/EnumType_class/__construct_method.md)


---
### __callStatic

Enum adından )key= yeni bir nesne örneği oluşturur.

```php
public static EnumType::__callStatic( $name,  $arguments): mixed
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `name` | **** |  |
| `arguments` | **** |  |


**Return Value (Dönüş değeri):**


mixed



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/EnumType_class/__callStatic_method.md)


---
### getValue

Enum değerini döndürür

```php
public EnumType::getValue(): int
```









**Return Value (Dönüş değeri):**

Enum değeri
int



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/EnumType_class/getValue_method.md)


---
### setValue

Enum değerini set eder.

```php
public EnumType::setValue(int|string $val): void
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `val` | **int|string** | Enum değeri ya da Enum key (adı) |


**Return Value (Dönüş değeri):**


void



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/EnumType_class/setValue_method.md)


---
### __toString

Enum adını (key) döndürür.

```php
public EnumType::__toString(): string
```









**Return Value (Dönüş değeri):**


string



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/EnumType_class/__toString_method.md)


---
### toInt

Enum değerini verir.

```php
public EnumType::toInt(): int
```









**Return Value (Dönüş değeri):**

Enum değeri
int



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/EnumType_class/toInt_method.md)


---


## Inherited methods (kalıtsal yöntemler)

### getEnumValue

Enum değerini döndürür.

```php
public static Enum::getEnumValue(string $key): int|null
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `key` | **string** | enum anahtarı (adı) |


**Return Value (Dönüş değeri):**

enum değeri
int|null



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/EnumType_class/getEnumValue_method.md)


---
### getEnumValues

Enum değerlerini dizi olarak döndürür. Enum keu (adı) => enum değeri

```php
public static Enum::getEnumValues(): array|int[]
```



* Bu yöntem **statiktir**.





**Return Value (Dönüş değeri):**

enum değerleri
array|int[]



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/EnumType_class/getEnumValues_method.md)


---
### getConstantsArray



```php
private static Enum::getConstantsArray(string $className): array
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `className` | **string** |  |


**Return Value (Dönüş değeri):**


array



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/EnumType_class/getConstantsArray_method.md)


---
### checkEnumKey

Enum key in mevcut olup olmadığını döndürür.

```php
public static Enum::checkEnumKey(string $key): bool
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `key` | **string** | Enum key (Adı) |


**Return Value (Dönüş değeri):**

Mevcutsa true değilse false
bool



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/EnumType_class/checkEnumKey_method.md)


---
### checkEnumValue

Enum değerinin mevcut olup olmadığını döndürür.

```php
public static Enum::checkEnumValue(int $value): bool
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `value` | **int** | Enum değeri |


**Return Value (Dönüş değeri):**

Değer mevcutsa true değilse false
bool



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/EnumType_class/checkEnumValue_method.md)


---
### getEnumDocComentObjects

Enum sabitlerinin docComment lerinde oluşan bir dizi döndürür.

```php
public static Enum::getEnumDocComentObjects(): array|\Gek\Infrastructure\Reflections\DocCommentObject[]
```



* Bu yöntem **statiktir**.





**Return Value (Dönüş değeri):**


array|\Gek\Infrastructure\Reflections\DocCommentObject[]



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/EnumType_class/getEnumDocComentObjects_method.md)


---


---
> 2022-04-14 tarihinde kaynak kod yorumlarından otomatik olarak oluşturulmuştur.
