---
title: \Gek\Infrastructure\ConstClass
footer: false
---

# ConstClass

ConstClass Sınıfı

String değerlerden oluşan sabitler tutar (Enum gibi ama string)

örnek: [ConstClass](../../../examples/Gek/Infrastructure/ConstClass_class/index.md)


* Full name (Tam Adı): `\Gek\Infrastructure\ConstClass`

**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/ConstClass_class/index.md)



## Methods (Yöntemler)

### getConstValue

Varilen sabit ismine göre sabitin değerini verir

```php
public static ConstClass::getConstValue(string $key): mixed|null
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `key` | **string** | Sbit ismi |


**Return Value (Dönüş değeri):**

sabit değeri ya da bulunamazsa null döner
mixed|null



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/ConstClass_class/getConstValue_method.md)


---
### getConstValues

Sabitleri dizi olarak göndürür

```php
public static ConstClass::getConstValues(): array
```



* Bu yöntem **statiktir**.





**Return Value (Dönüş değeri):**

sabitlerin olduğu dizi. sabit adı => sabit değeri
array



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/ConstClass_class/getConstValues_method.md)


---
### getConstantsArray

Sınıf ismine göre sabitleri dizi olarak döndürür

```php
private static ConstClass::getConstantsArray(string $className): array
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `className` | **string** | sınıf adı |


**Return Value (Dönüş değeri):**

sabitlerin olduğu dizi sabit adı => sabit değeri
array



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/ConstClass_class/getConstantsArray_method.md)


---
### checkConstKey

Sabit adının olup olmadığını kontrol eder

```php
public static ConstClass::checkConstKey(string $key): bool
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `key` | **string** |  |


**Return Value (Dönüş değeri):**


bool



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/ConstClass_class/checkConstKey_method.md)


---
### checkConstValue

Sabit değerinin olup olmadığını kontrol eder.

```php
public static ConstClass::checkConstValue(mixed $value): bool
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `value` | **mixed** |  |


**Return Value (Dönüş değeri):**


bool



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/ConstClass_class/checkConstValue_method.md)


---
### getConstDocCommentObjects

Sabitlerin DocCommentlerini dizi olarak verir.

```php
public static ConstClass::getConstDocCommentObjects(): array&lt;string,\Gek\Infrastructure\Reflections\DocCommentObject&gt;|\Gek\Infrastructure\Reflections\DocCommentObject[]
```



* Bu yöntem **statiktir**.





**Return Value (Dönüş değeri):**


array&lt;string,\Gek\Infrastructure\Reflections\DocCommentObject&gt;|\Gek\Infrastructure\Reflections\DocCommentObject[]



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/ConstClass_class/getConstDocCommentObjects_method.md)


---


---
> 2022-04-14 tarihinde kaynak kod yorumlarından otomatik olarak oluşturulmuştur.
