---
title: \Gek\Infrastructure\ClassHelper
footer: false
---

# ClassHelper

ClassHelper Sınıfı

Sınıf yansımaları (Reflections) için yardımcı sınıf.

örnek: [ClassHelper](../../../examples/Gek/Infrastructure/ClassHelper_class/index.md)


* Full name (Tam Adı): `\Gek\Infrastructure\ClassHelper`

**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/ClassHelper_class/index.md)



## Methods (Yöntemler)

### getDocCommentObject

Verilen Reflector nesnesinin docComment ini DocCommentObject olarak döndürür.

```php
public static ClassHelper::getDocCommentObject(\Reflector $reflection): \Gek\Infrastructure\Reflections\DocCommentObject
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `reflection` | **\Reflector** | Reflector nesnesi |


**Return Value (Dönüş değeri):**


\Gek\Infrastructure\Reflections\DocCommentObject



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/ClassHelper_class/getDocCommentObject_method.md)


---
### getMetaObject

Verilen nesnenin özelliklerini sitring olarak tutan bir nesne döndürür.

```php
public static ClassHelper::getMetaObject(object $obj): object
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `obj` | **object** | nesne |


**Return Value (Dönüş değeri):**

Meta nesnesi
object



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/ClassHelper_class/getMetaObject_method.md)


---
### createMetaObject

Verilen reflector den meta bilgilerini tutan nesne oluşturur

```php
private static ClassHelper::createMetaObject(\Reflector $reflected): object
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `reflected` | **\Reflector** | Reflector |


**Return Value (Dönüş değeri):**

Meta nesnesi
object



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/ClassHelper_class/createMetaObject_method.md)


---
### getMetaObjectClassName

Verilen sınıf adında meta bilgilerini tutan nesne oluşturur.

```php
public static ClassHelper::getMetaObjectClassName(string $className): object
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `className` | **string** | sınıf adı |


**Return Value (Dönüş değeri):**

Meta nesne
object



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/ClassHelper_class/getMetaObjectClassName_method.md)


---
### reflectObject

Verilen nesneni yansımasını (reflection) döndürür.

```php
public static ClassHelper::reflectObject(object $obj): \ReflectionObject
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `obj` | **object** | nesne |


**Return Value (Dönüş değeri):**

yansıma
\ReflectionObject



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/ClassHelper_class/reflectObject_method.md)


---
### reflectClass

Verilen sınıf isminden sınıfın yansımasını (reflection) döndürür.

```php
public static ClassHelper::reflectClass(string $className): \ReflectionClass
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `className` | **string** | Sınıf adı |


**Return Value (Dönüş değeri):**

yansıma
\ReflectionClass



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/ClassHelper_class/reflectClass_method.md)


---


---
> 2022-04-14 tarihinde kaynak kod yorumlarından otomatik olarak oluşturulmuştur.
