<?php


namespace Gek\Infrastructure\Tests\FlagExp;


use Gek\Infrastructure\FlagExp\BitwiseOrExpression;
use Gek\Infrastructure\FlagExp\IntValueExpression;
use PHPUnit\Framework\TestCase;

/**
 * Class BitwiseOrExpressionTest
 * @package Gek\Infrastructure\Tests\FlagExp
 */
class BitwiseOrExpressionTest extends TestCase
{

    public function testCalculateValue():void {
        $a = 8 | 16;
        $b = 4;
        $expA = new IntValueExpression($a);
        $expB = new IntValueExpression($b);
        $exp = new BitwiseOrExpression($expA,$expB);
        $this->assertEquals(
            $a | $b,
            $exp->calculateValue()
        );
    }

}
