<?php


namespace Gek\Infrastructure\Tests\FlagExp;


use Gek\Infrastructure\FlagExp\BitwiseAndExpression;
use Gek\Infrastructure\FlagExp\IntValueExpression;
use PHPUnit\Framework\TestCase;

/**
 * Class BitwiseAndExpressionTest
 * @package Gek\Infrastructure\Tests\FlagExp
 */
class BitwiseAndExpressionTest extends TestCase
{
    public function testCalculateValue():void {
        $a = 8 | 16;
        $b = 16;
        $expA = new IntValueExpression($a);
        $expB = new IntValueExpression($b);
        $exp = new BitwiseAndExpression($expA,$expB);

        $this->assertEquals(
            $a & $b,
            $exp->calculateValue()
        );
    }
}
