<?php


namespace Gek\Infrastructure\Tests;


use Gek\Infrastructure\Exceptions\InvalidArgumentException;
use Gek\Infrastructure\Exceptions\NotImplementedException;
use Gek\Infrastructure\Tests\Mocups\DummyEnumType;
use PHPUnit\Framework\TestCase;

/**
 * Class EnumTypeTest
 * @package Gek\Infrastructure\Tests
 */
class EnumTypeTest extends TestCase
{
    public function testConstructIntValue():void {
        $dm = new DummyEnumType(3);
        $this->assertEquals(
            3,
            $dm->toInt()
        );
        $this->assertEquals(
            'TEST3',
            $dm->__toString()
        );
    }
    public function testConstructInvalidIntValue():void {
        $this->expectException(InvalidArgumentException::class);
        $this->expectExceptionMessage('Set edilmeye çalışılan değer ("30") Enum tipinin değerleri arasında bulunamadı.');
        $dm = new DummyEnumType(30);
    }

    public function testConstructStringValue():void {
        $dm = new DummyEnumType('TEST2');
        $this->assertEquals(
            2,
            $dm->toInt()
        );
        $this->assertEquals(
            'TEST2',
            $dm->__toString()
        );
    }
    public function testConstructInvalidStringValue():void {
        $this->expectException(InvalidArgumentException::class);
        $this->expectExceptionMessage('Set edilmeye çalışılan değer ("TEST30") Enum tipinin değerleri arasında bulunamadı.');
        $dm = new DummyEnumType('TEST30');
    }

    public function testStaticFunc():void {
        $control = new DummyEnumType('TEST1');
        $t1 = DummyEnumType::TEST1();
        $this->assertEquals(
            $control,
            $t1
        );
        $this->assertEquals(
            DummyEnumType::TEST1,
            $t1->toInt()
        );

        $this->assertEquals(
            'TEST1',
            $t1->__toString()
        );
    }

    public function testInvalidStaticFunc():void {
        $this->expectException(NotImplementedException::class);
        $t1 = DummyEnumType::TEST33();
    }

    public function testToString():void {
        $t2 = DummyEnumType::TEST2();
        $this->assertEquals(
            'TEST2',
            $t2 . ''
        );
        $this->assertEquals(
            'TEST2',
            strval($t2)
        );
    }

    public function testToInt():void {
        $t3 = DummyEnumType::TEST3();
        $this->assertEquals(
            3,
            $t3->toInt()
        );
    }

    public function testGetValue():void {
        $t4 = DummyEnumType::TEST4();
        $this->assertEquals(
            4,
            $t4->getValue()
        );
    }

    public function testSetValueInt():void {
        $t = DummyEnumType::TEST3();
        $t->setValue(2);
        $this->assertEquals(
            2,
            $t->getValue()
        );
        $this->assertEquals(
            'TEST2',
            $t.''
        );
    }
    public function testSetValueString():void {
        $t = DummyEnumType::TEST3();
        $t->setValue('TEST2');
        $this->assertEquals(
            2,
            $t->getValue()
        );
        $this->assertEquals(
            'TEST2',
            $t.''
        );
    }

}
