<?php


namespace Gek\Infrastructure\Tests;


use Gek\Infrastructure\Tests\Mocups\IntEnum;
use PHPUnit\Framework\TestCase;

/**
 * Class EnumTest
 * @package Gek\Infrastructure\Tests
 */
class EnumTest extends TestCase
{

    public function testGetEnumValues()
    {
        $values = IntEnum::getEnumValues();
        $this->assertEquals([
            'TEST_ONE' => 1,
            'TEST_TWO' => 2,
            'TEST_THREE' => 3,
            'TEST_FOUR' => 4
        ], $values);


    }

    public function testGetEnumValue()
    {
        $value = IntEnum::getEnumValue('TEST_ONE');
        $this->assertEquals(
            IntEnum::TEST_ONE,
            $value
        );
        $this->assertTrue(is_int($value));
        $value = IntEnum::getEnumValue('INVALID_KEY');
        $this->assertEquals(
            null,
            $value
        );


    }

    public function testCheckEnumKey()
    {
        $value = IntEnum::checkEnumKey('TEST_ONE');
        $this->assertEquals(
            true,
            $value
        );
        $value = IntEnum::checkEnumKey('INVALID_KEY');
        $this->assertEquals(
            false,
            $value
        );
    }

    public function testCheckEnumValue()
    {
        $value = IntEnum::checkEnumValue(1);
        $this->assertEquals(
            true,
            $value
        );
        $value = IntEnum::checkEnumValue(60);
        $this->assertEquals(
            false,
            $value
        );
        $value = IntEnum::checkEnumValue('1');
        $this->assertEquals(
            true,
            $value
        );

        $this->expectException(\TypeError::class);
        $value = IntEnum::checkEnumValue('zsxdcfasdfsd');


    }

    public function testGetEnumDocComentObjects(): void
    {

        $docComObjs = IntEnum::getEnumDocComentObjects();
        $this->assertEquals(
            'test bir',
            $docComObjs['TEST_ONE']->getKey('label')
        );

    }

}

