<?php


namespace Gek\Infrastructure\Tests;


use Gek\Infrastructure\Tests\Mocups\MixedConstClass;
use PHPUnit\Framework\TestCase;

class ConstClassTest extends TestCase
{
    public function testGetConstValues()
    {


        $values = MixedConstClass::getConstValues();
        $this->assertEquals([
            'TEST_ONE' => true,
            'TEST_TWO' => 'TWO',
            'TEST_THREE' => 3,
            'TEST_FOUR' => 4.2
        ], $values);
    }

    public function testGetConstValue()
    {


        $value = MixedConstClass::getConstValue('TEST_ONE');
        $this->assertEquals(
            MixedConstClass::TEST_ONE,
            $value
        );
        $this->assertTrue(is_bool($value));

        $value = MixedConstClass::getConstValue('TEST_TWO');
        $this->assertEquals(
            MixedConstClass::TEST_TWO,
            $value
        );
        $this->assertTrue(is_string($value));

        $value = MixedConstClass::getConstValue('TEST_THREE');
        $this->assertEquals(
            MixedConstClass::TEST_THREE,
            $value
        );
        $this->assertTrue(is_int($value));

        $value = MixedConstClass::getConstValue('TEST_FOUR');
        $this->assertEquals(
            MixedConstClass::TEST_FOUR,
            $value
        );
        $this->assertTrue(is_float($value));

        $value = MixedConstClass::getConstValue('INVALID_KEY');
        $this->assertEquals(
            null,
            $value
        );
    }

    public function testCheckConstKey()
    {
        $value = MixedConstClass::checkConstKey('TEST_ONE');
        $this->assertEquals(
            true,
            $value
        );
        $value = MixedConstClass::checkConstKey('INVALID_KEY');
        $this->assertEquals(
            false,
            $value
        );
    }

    public function testCheckConstValue()
    {


        $value = MixedConstClass::checkConstValue('1');
        $this->assertEquals(
            false,
            $value
        );


        $this->assertEquals(
            true,
            MixedConstClass::checkConstValue(true)
        );

        $this->assertEquals(
            true,
            MixedConstClass::checkConstValue('TWO')
        );

        $this->assertEquals(
            false,
            MixedConstClass::checkConstValue('two')
        );

        $this->assertEquals(
            true,
            MixedConstClass::checkConstValue(4.2)
        );
        $this->assertEquals(
            true,
            MixedConstClass::checkConstValue(4.200)
        );
    }

    public function testGetConstDocCommentObjects(): void
    {

        $docComObjs = MixedConstClass::getConstDocCommentObjects();
        $this->assertEquals(
            'test bir',
            $docComObjs['TEST_ONE']->getKey('label')
        );

    }

}