<?php /** @noinspection PhpUnhandledExceptionInspection */


namespace Gek\Infrastructure\Math\DecimalExpressions;


use Gek\Infrastructure\Math\Decimal;

class DecimalSubExpression extends DecimalExpression
{
    public ?DecimalExpression $left;
    public ?DecimalExpression $right;

    public function __construct(?DecimalExpression $left = null, ?DecimalExpression $right = null)
    {
        $this->left = $left;
        $this->right = $right;
    }

    /**
     * @inheritDoc
     */
    public function calculateValue(): Decimal
    {
        return $this->left->calculateValue()->sub($this->right->calculateValue());
    }
}