<?php


namespace Gek\Infrastructure\FlagExp;


/**
 * Class BitwiseOrExpression
 * @package Gek\Infrastructure\FlagExp
 */
class BitwiseOrExpression extends FlagExpression
{
    public ?FlagExpression $left;
    public ?FlagExpression $right;

    /**
     * BitwiseOrExpression constructor.
     * @param FlagExpression|null $left
     * @param FlagExpression|null $right
     */
    public function __construct(?FlagExpression $left = null, ?FlagExpression $right = null)
    {
        $this->left = $left;
        $this->right = $right;
    }

    /**
     * @return int
     */
    public function calculateValue(): int
    {
        return $this->left->calculateValue() | $this->right->calculateValue();
    }
}
