<?php


namespace Gek\Infrastructure\Exceptions;


use Throwable;

/**
 * Class InvalidArgumentException
 * @package Gek\Infrastructure\Exceptions
 */
class InvalidArgumentException extends \InvalidArgumentException implements IInvalidArgumentException
{
    private ?string $argumentName;

    /**
     * GekException constructor.
     * @param string $message
     * @param int $code
     * @param Throwable|null $previous
     * @param string|null $argumentName
     */
    public function __construct($message = "", $code = 0, Throwable $previous = null, ?string $argumentName = null)
    {
        $this->argumentName = $argumentName;
        parent::__construct($message, $code, $previous);
    }

    /**
     * {@inheritDoc}
     */
    public function getArgumentName(): ?string
    {
        return $this->argumentName;
    }

}
