<?php


namespace Gek\Infrastructure\Tests\FlagExp;


use Gek\Infrastructure\Exceptions\GekException;
use Gek\Infrastructure\FlagExp\FlagExpressionParser;
use PHPUnit\Framework\TestCase;

/**
 * Class FlagExpressionParserTest
 * @package Gek\Infrastructure\Tests\FlagExp
 */
class FlagExpressionParserTest extends TestCase
{
    public function testParseValueBasic():void {
        $this->assertEquals(
            1 | 2,
            FlagExpressionParser::parseValue('1 | 2')
        );
        $this->assertEquals(
            1 | 2 | 4 | 8 | 16 | 32,
            FlagExpressionParser::parseValue('1 | 2 | 4 | 8 | 16 | 32')
        );
        $this->assertEquals(
            1 | (2 & 4) | 8 | (16 ^ 32),
            FlagExpressionParser::parseValue('1 | (2 & 4) | 8 | (16 ^ 32)')
        );
    }
    public function testParseValueInvalidValue():void {
        $this->expectException(GekException::class);
        FlagExpressionParser::parseValue('1 | 2 | 4 | 8 | 16 | 32 as');

    }

}
