<?php


namespace Gek\Infrastructure\Tests\FlagExp;


use Gek\Infrastructure\FlagExp\BitwiseXorExpression;
use Gek\Infrastructure\FlagExp\IntValueExpression;
use PHPUnit\Framework\TestCase;

/**
 * Class BitwiseXorExpressionTest
 * @package Gek\Infrastructure\Tests\FlagExp
 */
class BitwiseXorExpressionTest extends TestCase
{
    public function testCalculateValue():void {
        $a = 8 | 16;
        $b = 16;
        $expA = new IntValueExpression($a);
        $expB = new IntValueExpression($b);
        $exp = new BitwiseXorExpression($expA,$expB);
        $this->assertEquals(
            $a ^ $b,
            $exp->calculateValue()
        );
    }

}
