<?php


namespace Gek\Infrastructure\Tests;


use Gek\Infrastructure\Exceptions\ArgumentOutOfRangeException;
use Gek\Infrastructure\Exceptions\InvalidArgumentException;
use Gek\Infrastructure\Exceptions\NotImplementedException;
use Gek\Infrastructure\Tests\Mocups\DummyFlagEnumType;
use PHPUnit\Framework\TestCase;

/**
 * Class FlagEnumTypeTest
 * @package Gek\Infrastructure\Tests
 */
class FlagEnumTypeTest extends TestCase
{

    public function testConstructIntValue():void {
        $dm = new DummyFlagEnumType(2 | 8);
        $this->assertEquals(
            2 | 8,
            $dm->toInt()
        );
        $this->assertEquals(
            'TEST2 | TEST4',
            $dm->__toString()
        );
    }
    public function testConstructInvalidIntValue():void {
        $this->expectException(ArgumentOutOfRangeException::class);
        $this->expectExceptionMessage('value değeri (378545) flag değerini aşıyor.');
        $dm = new DummyFlagEnumType(378545);
    }

    public function testConstructStringValue():void {
        $dm = new DummyFlagEnumType('TEST2');
        $this->assertEquals(
            2,
            $dm->toInt()
        );
        $this->assertEquals(
            'TEST2',
            $dm->__toString()
        );
    }
    public function testConstructInvalidStringValue():void {
        $this->expectException(InvalidArgumentException::class);
        $this->expectExceptionMessage('Geçersiz flag key. ("TEST30")');
        $dm = new DummyFlagEnumType('TEST30');
    }

    public function testStaticFunc():void {
        $control = new DummyFlagEnumType('TEST1');
        $t1 = DummyFlagEnumType::TEST1();
        $this->assertEquals(
            $control,
            $t1
        );
        $this->assertEquals(
            DummyFlagEnumType::TEST1,
            $t1->toInt()
        );

        $this->assertEquals(
            'TEST1',
            $t1->__toString()
        );
    }

    public function testInvalidStaticFunc():void {
        $this->expectException(NotImplementedException::class);
        $t1 = DummyFlagEnumType::TEST33();
    }

    public function testToString():void {
        $t2 = DummyFlagEnumType::TEST2();
        $this->assertEquals(
            'TEST2',
            $t2 . ''
        );
        $this->assertEquals(
            'TEST2',
            strval($t2)
        );
        $t = new DummyFlagEnumType((DummyFlagEnumType::TEST1 | DummyFlagEnumType::TEST4 ) ^ DummyFlagEnumType::allFlags());
        $this->assertEquals(
            'TEST2 | TEST3 | TEST5',
            strval($t)
        );
    }

    public function testToInt():void {
        $t3 = DummyFlagEnumType::TEST3();
        $this->assertEquals(
            4,
            $t3->toInt()
        );
    }

    public function testGetValue():void {
        $t4 = DummyFlagEnumType::TEST4();
        $this->assertEquals(
            8,
            $t4->getValue()
        );
    }

    public function testSetValueInt():void {
        $t = DummyFlagEnumType::TEST3();
        $t->setValue(2);
        $this->assertEquals(
            2,
            $t->getValue()
        );
        $this->assertEquals(
            'TEST2',
            $t.''
        );
    }

    public function testSetValueString():void {
        $t = DummyFlagEnumType::TEST3();
        $t->setValue('TEST2');
        $this->assertEquals(
            2,
            $t->getValue()
        );
        $this->assertEquals(
            'TEST2',
            $t.''
        );
    }

}
